"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableWelcomeMessage = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _use_kibana = require("../application/hooks/use_kibana");
var _doc_links = require("../../common/doc_links");
var _use_conversation_list = require("../application/hooks/use_conversation_list");
var _send_message_context = require("../application/context/send_message/send_message_context");
var _use_has_connectors_all_privileges = require("../application/hooks/use_has_connectors_all_privileges");
var _storage_keys = require("../application/storage_keys");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/embeddable/embeddable_welcome_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EmbeddableWelcomeMessage = () => {
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const hasAccessToGenAiSettings = (0, _use_has_connectors_all_privileges.useHasConnectorsAllPrivileges)();
  const [showCallOut, setShowCallOut] = (0, _react.useState)(!localStorage.getItem(_storage_keys.storageKeys.welcomeMessageDismissed));
  const onDismiss = () => {
    localStorage.setItem(_storage_keys.storageKeys.welcomeMessageDismissed, 'true');
    setShowCallOut(false);
  };
  const {
    isResponseLoading
  } = (0, _send_message_context.useSendMessage)();

  // Dismiss the welcome message automatically when a message has been sent
  (0, _react.useEffect)(() => {
    if (isResponseLoading) {
      onDismiss();
    }
  }, [isResponseLoading]);
  const {
    conversations = [],
    isLoading
  } = (0, _use_conversation_list.useConversationList)();
  const hasNoConversations = isLoading === false && conversations.length === 0;

  // Only render the Welcome Message if the user has NO conversations AND the welcome message has not been dismissed
  if (!showCallOut || !hasNoConversations) return null;
  const documentationLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.agentBuilder,
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcomeMessage.documentationLink",
    defaultMessage: "documentation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }));
  const genAiSettingsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: application.getUrlForApp('management', {
      path: '/ai/genAiSettings'
    }),
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcomeMessage.genAiSettingsLink",
    defaultMessage: "GenAI Settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    css: (0, _react2.css)`
        padding: ${euiTheme.size.base};
        flex-grow: 0;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.welcomeMessage.title",
      defaultMessage: "Welcome to our new agentic experience",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }),
    iconType: "info",
    onDismiss: onDismiss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, hasAccessToGenAiSettings ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcomeMessage.contentAdvanced",
    defaultMessage: "Based on the new <strong>Agent Builder</strong> platform, <strong>AI Agent</strong> is the new agentic chat experience for this space. Learn more in our {documentationLink} or switch back to the default experience in the {genAiSettingsLink}.",
    values: {
      strong: chunks => /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 52
        }
      }, chunks),
      documentationLink,
      genAiSettingsLink
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcomeMessage.content",
    defaultMessage: "Based on the new <strong>Agent Builder</strong> platform, <strong>AI Agent</strong> is the new agentic chat experience for this space. Learn more in our {documentationLink}.",
    values: {
      strong: chunks => /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 52
        }
      }, chunks),
      documentationLink
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  })));
};
exports.EmbeddableWelcomeMessage = EmbeddableWelcomeMessage;