"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatNavControl = OnechatNavControl;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _robot = require("../../application/components/common/icons/robot");
var _use_ui_privileges = require("../../application/hooks/use_ui_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/components/nav_control/onechat_nav_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isMac = navigator.platform.toLowerCase().indexOf('mac') >= 0;
const isSemicolon = event => event.code === 'Semicolon' || event.key === ';';
function OnechatNavControl() {
  const {
    services: {
      onechat,
      aiAssistantManagementSelection
    }
  } = (0, _public.useKibana)();
  const {
    show: hasShowPrivilege
  } = (0, _use_ui_privileges.useUiPrivileges)();
  const toggleFlyout = (0, _react.useCallback)(() => {
    onechat.toggleConversationFlyout();
  }, [onechat]);
  (0, _react.useEffect)(() => {
    if (!hasShowPrivilege) {
      return;
    }
    const openChatSubscription = aiAssistantManagementSelection.openChat$.subscribe(selection => {
      if (selection === _aiAssistantCommon.AIChatExperience.Agent) {
        onechat.openConversationFlyout();
        aiAssistantManagementSelection.completeOpenChat();
      }
    });
    return () => {
      openChatSubscription.unsubscribe();
    };
  }, [hasShowPrivilege, onechat, aiAssistantManagementSelection]);
  const onKeyDown = (0, _react.useCallback)(event => {
    if (isSemicolon(event) && (isMac ? event.metaKey : event.ctrlKey)) {
      event.preventDefault();
      toggleFlyout();
    }
  }, [toggleFlyout]);
  if (!hasShowPrivilege) {
    return null;
  }
  const tooltipContent = /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, buttonLabel), /*#__PURE__*/_react.default.createElement("br", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, shortcutLabel));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": buttonLabel,
    "data-test-subj": "OnechatNavControlButton",
    onClick: () => {
      toggleFlyout();
    },
    color: "primary",
    size: "s",
    fullWidth: false,
    minWidth: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_robot.RobotIcon, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.navControl.linkLabel",
    defaultMessage: "AI Agent",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }))));
}
const buttonLabel = _i18n.i18n.translate('xpack.onechat.navControl.openTheOnechatFlyoutLabel', {
  defaultMessage: 'Open Agent Builder'
});
const shortcutLabel = _i18n.i18n.translate('xpack.onechat.navControl.keyboardShortcutTooltip', {
  values: {
    keyboardShortcut: isMac ? '⌘ ;' : 'Ctrl ;'
  },
  defaultMessage: '(Keyboard shortcut {keyboardShortcut})'
});