"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListMcpTools = exports.useListConnectors = exports.useGetConnector = void 0;
var _reactQuery = require("@kbn/react-query");
var _query_keys = require("../../query_keys");
var _use_onechat_service = require("../use_onechat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_CONNECTORS = [];
const EMPTY_TOOLS = [];
const useListConnectors = ({
  type
}) => {
  var _data$connectors;
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    data,
    ...queryFields
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.tools.connectors.list(type),
    queryFn: () => toolsService.listConnectors({
      type
    })
  });
  return {
    connectors: (_data$connectors = data === null || data === void 0 ? void 0 : data.connectors) !== null && _data$connectors !== void 0 ? _data$connectors : EMPTY_CONNECTORS,
    ...queryFields
  };
};
exports.useListConnectors = useListConnectors;
const useGetConnector = ({
  connectorId
}) => {
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    data,
    ...queryFields
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.tools.connectors.get(connectorId),
    queryFn: () => toolsService.getConnector({
      connectorId
    }),
    enabled: !!connectorId
  });
  return {
    connector: data === null || data === void 0 ? void 0 : data.connector,
    ...queryFields
  };
};
exports.useGetConnector = useGetConnector;
const useListMcpTools = ({
  connectorId
}) => {
  var _data$mcpTools;
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    data,
    ...queryFields
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.tools.connectors.listMcpTools(connectorId),
    queryFn: () => toolsService.listMcpTools({
      connectorId
    }),
    enabled: !!connectorId
  });
  return {
    mcpTools: (_data$mcpTools = data === null || data === void 0 ? void 0 : data.mcpTools) !== null && _data$mcpTools !== void 0 ? _data$mcpTools : EMPTY_TOOLS,
    ...queryFields
  };
};
exports.useListMcpTools = useListMcpTools;