"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkImportMcpTools = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_onechat_service = require("../use_onechat_service");
var _query_keys = require("../../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBulkImportMcpTools = () => {
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)({
    mutationFn: async ({
      connectorId,
      tools,
      namespace,
      tags,
      skipExisting
    }) => {
      return toolsService.bulkCreateMcpTools({
        connectorId,
        tools,
        namespace,
        tags,
        skipExisting
      });
    },
    onSuccess: () => {
      queryClient.invalidateQueries({
        queryKey: _query_keys.queryKeys.tools.all
      });
    }
  });
};
exports.useBulkImportMcpTools = useBulkImportMcpTools;