"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolsActions = exports.ToolsProvider = exports.ToolsActionsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _app_paths = require("../utils/app_paths");
var _use_navigation = require("../hooks/use_navigation");
var _use_delete_tools = require("../hooks/tools/use_delete_tools");
var _i18n = require("../utils/i18n");
var _create_tool = require("../components/tools/create_tool");
var _test_tools = require("../components/tools/execute/test_tools");
var _use_query_state = require("../hooks/use_query_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/context/tools_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ToolsActionsContext = exports.ToolsActionsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const ToolsProvider = ({
  children
}) => {
  const {
    navigateToOnechatUrl,
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const createTool = (0, _react.useCallback)(toolType => {
    navigateToOnechatUrl(_app_paths.appPaths.tools.new, {
      [_create_tool.TOOL_TYPE_QUERY_PARAM]: toolType
    });
  }, [navigateToOnechatUrl]);
  const getCreateToolUrl = (0, _react.useCallback)(toolType => {
    return createOnechatUrl(_app_paths.appPaths.tools.new, {
      [_create_tool.TOOL_TYPE_QUERY_PARAM]: toolType
    });
  }, [createOnechatUrl]);
  const editTool = (0, _react.useCallback)(toolId => {
    navigateToOnechatUrl(_app_paths.appPaths.tools.details({
      toolId
    }));
  }, [navigateToOnechatUrl]);
  const viewTool = (0, _react.useCallback)(toolId => {
    navigateToOnechatUrl(_app_paths.appPaths.tools.details({
      toolId
    }));
  }, [navigateToOnechatUrl]);
  const [testToolId, setTestToolId] = (0, _react.useState)(null);
  const [testToolIdParam, setTestToolIdParam] = (0, _use_query_state.useQueryState)(_create_tool.TEST_TOOL_ID_QUERY_PARAM);

  // Handle opening test flyout from query param (one-time trigger, then clear param)
  (0, _react.useEffect)(() => {
    if (testToolIdParam && !testToolId) {
      setTestToolId(testToolIdParam);
      setTestToolIdParam(null);
    }
  }, [testToolIdParam, testToolId, setTestToolIdParam]);
  const testTool = (0, _react.useCallback)(toolId => {
    setTestToolId(toolId);
  }, []);
  const closeTestFlyout = (0, _react.useCallback)(() => {
    setTestToolId(null);
  }, []);
  const getEditToolUrl = (0, _react.useCallback)(toolId => {
    return createOnechatUrl(_app_paths.appPaths.tools.details({
      toolId
    }));
  }, [createOnechatUrl]);
  const getViewToolUrl = (0, _react.useCallback)(toolId => {
    return createOnechatUrl(_app_paths.appPaths.tools.details({
      toolId
    }));
  }, [createOnechatUrl]);
  const cloneTool = (0, _react.useCallback)(toolId => {
    navigateToOnechatUrl(_app_paths.appPaths.tools.new, {
      [_create_tool.TOOL_SOURCE_QUERY_PARAM]: toolId
    });
  }, [navigateToOnechatUrl]);
  const getCloneToolUrl = (0, _react.useCallback)(toolId => {
    return createOnechatUrl(_app_paths.appPaths.tools.new, {
      [_create_tool.TOOL_SOURCE_QUERY_PARAM]: toolId
    });
  }, [createOnechatUrl]);
  const {
    isOpen: isDeleteModalOpen,
    isLoading: isDeletingTool,
    toolId: deleteToolId,
    deleteTool,
    confirmDelete,
    cancelDelete
  } = (0, _use_delete_tools.useDeleteTool)();
  const {
    isOpen: isBulkDeleteToolsModalOpen,
    isLoading: isBulkDeletingTools,
    toolIds: bulkDeleteToolIds,
    deleteTools: bulkDeleteTools,
    confirmDelete: confirmBulkDeleteTools,
    cancelDelete: cancelBulkDeleteTools
  } = (0, _use_delete_tools.useDeleteTools)();
  const deleteEsqlToolTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'deleteEsqlToolTitle'
  });
  const bulkDeleteEsqlToolsTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'bulkDeleteEsqlToolsTitle'
  });
  return /*#__PURE__*/_react.default.createElement(ToolsActionsContext.Provider, {
    value: {
      deleteTool,
      bulkDeleteTools,
      createTool,
      editTool,
      viewTool,
      cloneTool,
      testTool,
      getCreateToolUrl,
      getEditToolUrl,
      getViewToolUrl,
      getCloneToolUrl
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, children, isDeleteModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: deleteToolId ? _i18n.labels.tools.deleteEsqlToolTitle(deleteToolId) : '',
    "aria-labelledby": deleteEsqlToolTitleId,
    titleProps: {
      id: deleteEsqlToolTitleId
    },
    onCancel: cancelDelete,
    onConfirm: confirmDelete,
    isLoading: isDeletingTool,
    cancelButtonText: _i18n.labels.tools.deleteEsqlToolCancelButton,
    confirmButtonText: _i18n.labels.tools.deleteEsqlToolConfirmButton,
    buttonColor: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, _i18n.labels.tools.deleteEsqlToolConfirmationText)), isBulkDeleteToolsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.labels.tools.bulkDeleteEsqlToolsTitle(bulkDeleteToolIds.length),
    "aria-labelledby": bulkDeleteEsqlToolsTitleId,
    titleProps: {
      id: bulkDeleteEsqlToolsTitleId
    },
    onCancel: cancelBulkDeleteTools,
    onConfirm: confirmBulkDeleteTools,
    isLoading: isBulkDeletingTools,
    cancelButtonText: _i18n.labels.tools.deleteEsqlToolCancelButton,
    confirmButtonText: _i18n.labels.tools.deleteEsqlToolConfirmButton,
    buttonColor: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, _i18n.labels.tools.bulkDeleteEsqlToolsConfirmationText)), testToolId && /*#__PURE__*/_react.default.createElement(_test_tools.ToolTestFlyout, {
    toolId: testToolId,
    onClose: closeTestFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 22
    }
  }));
};
exports.ToolsProvider = ToolsProvider;
const useToolsActions = () => {
  const context = (0, _react.useContext)(ToolsActionsContext);
  if (!context) {
    throw new Error('useToolsActions must be used within a ToolsProvider');
  }
  return context;
};
exports.useToolsActions = useToolsActions;