"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendMessageMutation = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _browser_api_tool = require("@kbn/onechat-browser/tools/browser_api_tool");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_conversation = require("../../hooks/use_conversation");
var _conversation_context = require("../conversation/conversation_context");
var _use_conversation_id = require("../conversation/use_conversation_id");
var _use_onechat_service = require("../../hooks/use_onechat_service");
var _mutation_keys = require("../../mutation_keys");
var _use_pending_message_state = require("./use_pending_message_state");
var _use_subscribe_to_chat_events = require("./use_subscribe_to_chat_events");
var _browser_tool_executor = require("../../services/browser_tool_executor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSendMessageMutation = ({
  connectorId
} = {}) => {
  var _services$notificatio2;
  const {
    chatService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    conversationActions,
    attachments,
    resetAttachments,
    browserApiTools
  } = (0, _conversation_context.useConversationContext)();
  const [isResponseLoading, setIsResponseLoading] = (0, _react.useState)(false);
  const [agentReasoning, setAgentReasoning] = (0, _react.useState)(null);
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const {
    conversation
  } = (0, _use_conversation.useConversation)();
  const isMutatingNewConversationRef = (0, _react.useRef)(false);
  const agentId = (0, _use_conversation.useAgentId)();
  const messageControllerRef = (0, _react.useRef)(null);
  const [error, setError] = (0, _react.useState)(null);
  const [errorSteps, setErrorSteps] = (0, _react.useState)([]);
  const removeError = (0, _react.useCallback)(() => {
    setError(null);
    setErrorSteps([]);
  }, []);
  (0, _react.useEffect)(() => {
    // Clear errors any time conversation id changes - we do not persist it.
    if (conversationId) {
      removeError();
    }
  }, [conversationId, removeError]);
  const browserApiToolsMetadata = (0, _react.useMemo)(() => {
    if (!browserApiTools) return undefined;
    return browserApiTools.map(_browser_api_tool.toToolMetadata);
  }, [browserApiTools]);
  const browserToolExecutor = (0, _react.useMemo)(() => {
    var _services$notificatio;
    return new _browser_tool_executor.BrowserToolExecutor((_services$notificatio = services.notifications) === null || _services$notificatio === void 0 ? void 0 : _services$notificatio.toasts);
  }, [(_services$notificatio2 = services.notifications) === null || _services$notificatio2 === void 0 ? void 0 : _services$notificatio2.toasts]);
  const {
    pendingMessageState: {
      pendingMessage
    },
    setPendingMessage,
    removePendingMessage
  } = (0, _use_pending_message_state.usePendingMessageState)({
    conversationId
  });
  const {
    subscribeToChatEvents,
    unsubscribeFromChatEvents
  } = (0, _use_subscribe_to_chat_events.useSubscribeToChatEvents)({
    setAgentReasoning,
    setIsResponseLoading,
    isAborted: () => {
      var _messageControllerRef, _messageControllerRef2;
      return Boolean(messageControllerRef === null || messageControllerRef === void 0 ? void 0 : (_messageControllerRef = messageControllerRef.current) === null || _messageControllerRef === void 0 ? void 0 : (_messageControllerRef2 = _messageControllerRef.signal) === null || _messageControllerRef2 === void 0 ? void 0 : _messageControllerRef2.aborted);
    },
    browserToolExecutor
  });
  const sendMessage = async ({
    message
  }) => {
    var _messageControllerRef3;
    const signal = (_messageControllerRef3 = messageControllerRef.current) === null || _messageControllerRef3 === void 0 ? void 0 : _messageControllerRef3.signal;
    if (!signal) {
      return Promise.reject(new Error('Abort signal not present'));
    }
    const events$ = chatService.chat({
      signal,
      input: message,
      conversationId,
      agentId,
      connectorId,
      attachments: attachments !== null && attachments !== void 0 ? attachments : [],
      browserApiTools: browserApiToolsMetadata
    });
    return subscribeToChatEvents(events$);
  };
  const {
    mutate,
    isLoading
  } = (0, _reactQuery.useMutation)({
    mutationKey: _mutation_keys.mutationKeys.sendMessage,
    mutationFn: sendMessage,
    onMutate: ({
      message
    }) => {
      const isNewConversation = !conversationId;
      isMutatingNewConversationRef.current = isNewConversation;
      setPendingMessage(message);
      removeError();
      messageControllerRef.current = new AbortController();
      conversationActions.addOptimisticRound({
        userMessage: message,
        attachments: attachments !== null && attachments !== void 0 ? attachments : []
      });
      if (isNewConversation) {
        if (!agentId) {
          throw new Error('Agent id must be defined for a new conversation');
        }
        conversationActions.setAgentId(agentId);
      }
      setIsResponseLoading(true);
    },
    onSettled: () => {
      conversationActions.invalidateConversation();
      messageControllerRef.current = null;
      setAgentReasoning(null);
      if (isResponseLoading) {
        setIsResponseLoading(false);
      }
    },
    onSuccess: () => {
      removePendingMessage();
      resetAttachments === null || resetAttachments === void 0 ? void 0 : resetAttachments();
      if (isMutatingNewConversationRef.current) {
        conversationActions.removeNewConversationQuery();
      }
    },
    onError: err => {
      var _conversation$rounds, _conversation$rounds$;
      setError(err);
      const steps = conversation === null || conversation === void 0 ? void 0 : (_conversation$rounds = conversation.rounds) === null || _conversation$rounds === void 0 ? void 0 : (_conversation$rounds$ = _conversation$rounds.at(-1)) === null || _conversation$rounds$ === void 0 ? void 0 : _conversation$rounds$.steps;
      if (steps) {
        setErrorSteps(steps);
      }
      // When we error, we should immediately remove the round rather than waiting for a refetch after invalidation
      // Otherwise, the error round and the optimistic round will be visible together.
      conversationActions.removeOptimisticRound();
    }
  });
  const canCancel = isLoading;
  const cancel = () => {
    var _messageControllerRef4;
    if (!canCancel) {
      return;
    }
    removePendingMessage();
    (_messageControllerRef4 = messageControllerRef.current) === null || _messageControllerRef4 === void 0 ? void 0 : _messageControllerRef4.abort();
  };
  return {
    sendMessage: mutate,
    isResponseLoading,
    error,
    errorSteps,
    pendingMessage,
    agentReasoning,
    retry: () => {
      if (
      // Retrying should not be allowed if a response is still being fetched
      // or if we're not in an error state
      isResponseLoading || !error) {
        return;
      }
      if (!pendingMessage) {
        // Should never happen
        // If we are in an error state, pending message will be present
        throw new Error('Pending message is not present');
      }
      mutate({
        message: pendingMessage
      });
    },
    canCancel,
    cancel,
    cleanConversation: () => {
      // Cleaning the conversation only happens when we are on "/new" and the user wants to back out of a pending or errored conversation and return to an empty conversation state
      if (isLoading) {
        // Conversation round is pending, unsubscribe from chat events and resolve mutation
        unsubscribeFromChatEvents();
      } else if (Boolean(error)) {
        removeError();
        removePendingMessage();
      }
    }
  };
};
exports.useSendMessageMutation = useSendMessageMutation;