"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentBuilderTour = exports.TourStep = exports.AgentBuilderTourProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _storage_keys = require("../storage_keys");
var _conversation_context = require("./conversation/conversation_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/context/agent_builder_tour_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let TourStep = exports.TourStep = /*#__PURE__*/function (TourStep) {
  TourStep["AgentSelector"] = "agent-selector";
  TourStep["LlmSelector"] = "llm-selector";
  TourStep["ConversationsHistory"] = "conversations-history";
  TourStep["ConversationActions"] = "conversation-actions";
  return TourStep;
}({});
const AgentBuilderTourContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const DEFAULT_STEP = 1;
const TOUR_DELAY = 250; // 250ms

const tourConfig = {
  tourPopoverWidth: 370,
  anchorPosition: 'downCenter',
  maxSteps: 4
};
const labels = {
  agentSelector: {
    title: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.agentSelector.title', {
      defaultMessage: 'Meet your active agent 🕵️‍♂️'
    }),
    content: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.agentSelector.content', {
      defaultMessage: "An agent's behavior is defined by its custom instructions and available tools. Switch agents when you need different capabilities for your tasks."
    })
  },
  llmSelector: {
    title: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.llmSelector.title', {
      defaultMessage: 'Select your LLM 🧠'
    }),
    content: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.llmSelector.content', {
      defaultMessage: 'Your agent uses this model to generate responses. Switch LLMs to prioritize faster responses, lower costs, or more complex reasoning.'
    })
  },
  // TODO: Add prompts step once we have prompts.
  // prompts: {
  //   title: i18n.translate('xpack.onechat.agentBuilderTour.prompts.title', {
  //     defaultMessage: 'Reuse your prompts ✍️',
  //   }),
  //   content: i18n.translate('xpack.onechat.agentBuilderTour.prompts.content', {
  //     defaultMessage: 'Store your favorite queries here. Pick one to drop it into the chat.',
  //   }),
  // },
  conversationsHistory: {
    title: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.conversationsHistory.title', {
      defaultMessage: 'Browse your conversations 💬'
    }),
    content: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.conversationsHistory.content', {
      defaultMessage: 'Find all your previous conversations here.'
    })
  },
  conversationActions: {
    title: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.conversationActions.title', {
      defaultMessage: 'Jump to key actions ⚙️'
    }),
    content: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.conversationActions.content', {
      defaultMessage: 'This menu is your hub for key management actions. You can quickly access important pages from here.'
    })
  },
  closeTour: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.closeTour', {
    defaultMessage: 'Close tour'
  }),
  next: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.next', {
    defaultMessage: 'Next'
  }),
  finishTour: _i18n.i18n.translate('xpack.onechat.agentBuilderTour.finishTour', {
    defaultMessage: 'Finish tour'
  })
};
const AgentBuilderTourProvider = ({
  children
}) => {
  const {
    isEmbeddedContext
  } = (0, _conversation_context.useConversationContext)();
  const [currentStep, setCurrentStep] = (0, _react.useState)(DEFAULT_STEP);
  const [isTourActive, setIsTourActive] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const hasSeenTour = localStorage.getItem(_storage_keys.storageKeys.hasSeenAgentBuilderTour);
    let timer;
    if (!isEmbeddedContext && !hasSeenTour) {
      // We use a delay to ensure the tour is not triggered immediately when the page loads to ensure correct anchor positioning.
      timer = setTimeout(() => {
        setIsTourActive(true);
      }, TOUR_DELAY);
    }
    return () => {
      if (timer) {
        clearTimeout(timer);
      }
    };
  }, [isEmbeddedContext]);
  const handleMoveToNextStep = () => {
    setCurrentStep(prev => prev + 1);
  };
  const handleFinishTour = () => {
    setIsTourActive(false);
    localStorage.setItem(_storage_keys.storageKeys.hasSeenAgentBuilderTour, 'true');
  };
  const footerActions = [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    onClick: handleFinishTour,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }, labels.closeTour), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    size: "s",
    onClick: handleMoveToNextStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 5
    }
  }, labels.next)];
  const footerActionsFinish = [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    size: "s",
    onClick: handleFinishTour,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 5
    }
  }, labels.finishTour)];
  const tourSteps = {
    [TourStep.AgentSelector]: {
      title: labels.agentSelector.title,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 11
        }
      }, labels.agentSelector.content)),
      footerActions,
      step: 1
    },
    [TourStep.LlmSelector]: {
      title: labels.llmSelector.title,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 11
        }
      }, labels.llmSelector.content)),
      footerActions,
      step: 2
    },
    [TourStep.ConversationsHistory]: {
      title: labels.conversationsHistory.title,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 11
        }
      }, labels.conversationsHistory.content)),
      footerActions,
      step: 3
    },
    [TourStep.ConversationActions]: {
      title: labels.conversationActions.title,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 11
        }
      }, labels.conversationActions.content)),
      footerActions: footerActionsFinish,
      step: 4
    }
  };
  const getStepProps = step => {
    const stepConfig = tourSteps[step];
    return {
      maxWidth: tourConfig.tourPopoverWidth,
      isStepOpen: currentStep === stepConfig.step && isTourActive,
      title: stepConfig.title,
      content: stepConfig.content,
      onFinish: handleFinishTour,
      step: stepConfig.step,
      stepsTotal: tourConfig.maxSteps,
      anchorPosition: tourConfig.anchorPosition,
      footerAction: stepConfig.footerActions
    };
  };
  const contextValue = {
    isTourActive,
    getStepProps
  };
  return /*#__PURE__*/_react.default.createElement(AgentBuilderTourContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 5
    }
  }, children);
};
exports.AgentBuilderTourProvider = AgentBuilderTourProvider;
const useAgentBuilderTour = () => {
  const context = (0, _react.useContext)(AgentBuilderTourContext);
  if (!context) {
    throw new Error('useAgentBuilderTour must be used within an AgentBuilderTourProvider');
  }
  return context;
};
exports.useAgentBuilderTour = useAgentBuilderTour;