"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolsTableColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_ui_privileges = require("../../../hooks/use_ui_privileges");
var _i18n = require("../../../utils/i18n");
var _tool_tags = require("../tags/tool_tags");
var _tools_table_context_menu = require("./tools_table_context_menu");
var _tools_table_id = require("./tools_table_id");
var _tools_table_quick_actions = require("./tools_table_quick_actions");
var _use_tools_health = require("../../../hooks/tools/use_tools_health");
var _mcp = require("../form/types/mcp");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/table/tools_table_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const healthStatusMessages = {
  [_mcp.McpToolHealthStatus.ToolNotFound]: {
    title: _i18n.labels.tools.mcpHealthStatus.toolNotFound.title,
    description: _i18n.labels.tools.mcpHealthStatus.toolNotFound.description
  },
  [_mcp.McpToolHealthStatus.ConnectorNotFound]: {
    title: _i18n.labels.tools.mcpHealthStatus.connectorNotFound.title,
    description: _i18n.labels.tools.mcpHealthStatus.connectorNotFound.description
  },
  [_mcp.McpToolHealthStatus.ListToolsFailed]: {
    title: _i18n.labels.tools.mcpHealthStatus.listToolsFailed.title,
    description: _i18n.labels.tools.mcpHealthStatus.listToolsFailed.description
  },
  [_mcp.McpToolHealthStatus.ToolUnhealthy]: {
    title: _i18n.labels.tools.mcpHealthStatus.toolUnhealthy.title,
    description: _i18n.labels.tools.mcpHealthStatus.toolUnhealthy.description
  }
};
const useToolsTableColumns = () => {
  const {
    manageTools
  } = (0, _use_ui_privileges.useUiPrivileges)();
  const {
    mcpHealthStates
  } = (0, _use_tools_health.useMcpToolsHealth)();
  return (0, _react.useMemo)(() => [
  // Status indicator
  {
    width: '30px',
    render: tool => {
      if (tool.readonly) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: "lock",
          content: _i18n.labels.tools.readOnly,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 53,
            columnNumber: 20
          }
        });
      }
      const mcpHealthState = mcpHealthStates.find(state => state.toolId === tool.id);
      if (!mcpHealthState || mcpHealthState.status === _mcp.McpToolHealthStatus.Healthy) {
        return null;
      }
      const status = mcpHealthState.status;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: _mcp.mcpUnhealthyStatusIconMap[status],
        color: "danger",
        title: healthStatusMessages[status].title,
        content: healthStatusMessages[status].description,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 13
        }
      });
    }
  }, {
    field: 'id',
    name: _i18n.labels.tools.toolIdLabel,
    sortable: true,
    width: '60%',
    render: (_, tool) => /*#__PURE__*/_react.default.createElement(_tools_table_id.ToolIdWithDescription, {
      tool: tool,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 54
      }
    })
  }, {
    field: 'tags',
    name: _i18n.labels.tools.tagsLabel,
    render: tags => /*#__PURE__*/_react.default.createElement(_tool_tags.OnechatToolTags, {
      tags: tags,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 37
      }
    })
  }, {
    width: '100px',
    align: 'right',
    render: tool => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "flexEnd",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    }, !tool.readonly && manageTools && /*#__PURE__*/_react.default.createElement(_tools_table_quick_actions.ToolQuickActions, {
      tool: tool,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 47
      }
    }), /*#__PURE__*/_react.default.createElement(_tools_table_context_menu.ToolContextMenu, {
      tool: tool,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    }))
  }], [manageTools, mcpHealthStates]);
};
exports.useToolsTableColumns = useToolsTableColumns;