"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mcpUnhealthyStatusIconMap = exports.McpToolHealthStatus = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let McpToolHealthStatus = exports.McpToolHealthStatus = /*#__PURE__*/function (McpToolHealthStatus) {
  McpToolHealthStatus["Healthy"] = "healthy";
  McpToolHealthStatus["ToolNotFound"] = "tool_not_found";
  McpToolHealthStatus["ConnectorNotFound"] = "connector_not_found";
  McpToolHealthStatus["ListToolsFailed"] = "list_tools_failed";
  McpToolHealthStatus["ToolUnhealthy"] = "tool_unhealthy";
  return McpToolHealthStatus;
}({});
const mcpUnhealthyStatusIconMap = exports.mcpUnhealthyStatusIconMap = {
  [McpToolHealthStatus.ToolNotFound]: 'magnifyWithExclamation',
  [McpToolHealthStatus.ConnectorNotFound]: 'unlink',
  [McpToolHealthStatus.ListToolsFailed]: 'unlink',
  [McpToolHealthStatus.ToolUnhealthy]: 'warning'
};