"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _tool_form_section = require("../components/tool_form_section");
var _i18n = require("../i18n");
var _tool_form = require("../tool_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/sections/details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DetailsSection = ({
  mode
}) => {
  var _errors$toolId, _errors$description;
  const {
    control,
    formState: {
      errors
    }
  } = (0, _reactHookForm.useFormContext)();
  const descriptionRef = (0, _react.useRef)(null);
  const isReadOnly = mode === _tool_form.ToolFormMode.View;
  const isToolIdDisabled = mode === _tool_form.ToolFormMode.Edit || isReadOnly;
  return /*#__PURE__*/_react.default.createElement(_tool_form_section.ToolFormSection, {
    title: _i18n.i18nMessages.systemReferences.documentation.title,
    icon: "bullseye",
    description: _i18n.i18nMessages.systemReferences.documentation.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "agentBuilderToolIdRow",
    isDisabled: isToolIdDisabled,
    label: _i18n.i18nMessages.systemReferences.form.toolId.label,
    isInvalid: !!errors.toolId,
    helpText: _i18n.i18nMessages.systemReferences.form.toolId.helpText,
    error: (_errors$toolId = errors.toolId) === null || _errors$toolId === void 0 ? void 0 : _errors$toolId.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "toolId",
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState: {
        invalid
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      "data-test-subj": "agentBuilderToolIdInput",
      disabled: isToolIdDisabled,
      placeholder: "namespace.tool_name (e.g., acme.financial.search)",
      readOnly: isReadOnly
    }, field, {
      inputRef: ref,
      isInvalid: invalid,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "agentBuilderToolDescriptionRow",
    label: _i18n.i18nMessages.systemReferences.form.description.label,
    isInvalid: !!errors.description,
    error: (_errors$description = errors.description) === null || _errors$description === void 0 ? void 0 : _errors$description.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "description",
    render: ({
      field: {
        ref,
        ...field
      }
    }) => {
      var _descriptionRef$curre;
      ref((_descriptionRef$curre = descriptionRef.current) === null || _descriptionRef$curre === void 0 ? void 0 : _descriptionRef$curre.textarea);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, (0, _extends2.default)({
        "data-test-subj": "agentBuilderToolDescriptionEditor",
        "aria-label": _i18n.i18nMessages.systemReferences.form.description.label,
        readOnly: isReadOnly,
        ref: descriptionRef
      }, field, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 15
        }
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  })));
};
exports.DetailsSection = DetailsSection;