"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nMessages = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nMessages = exports.i18nMessages = {
  paramUnusedWarning: name => _i18n.i18n.translate('xpack.onechat.tools.newTool.paramUnusedWarning', {
    defaultMessage: 'Parameter "{name}" is not used in the ES|QL query.',
    values: {
      name
    }
  }),
  paramNameLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.paramNameLabel', {
    defaultMessage: 'Name'
  }),
  paramNamePlaceholder: _i18n.i18n.translate('xpack.onechat.tools.newTool.paramNamePlaceholder', {
    defaultMessage: 'Name'
  }),
  paramDescriptionLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.paramDescriptionLabel', {
    defaultMessage: 'Description'
  }),
  paramDescriptionPlaceholder: _i18n.i18n.translate('xpack.onechat.tools.newTool.paramDescriptionPlaceholder', {
    defaultMessage: 'Description'
  }),
  paramTypeLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.paramTypeLabel', {
    defaultMessage: 'Type'
  }),
  optionalParamLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.optionalParamLabel', {
    defaultMessage: 'Optional'
  }),
  removeParamButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.removeParamButtonLabel', {
    defaultMessage: 'Remove parameter'
  }),
  addParamButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.addParamButtonLabel', {
    defaultMessage: 'Add a parameter'
  }),
  inferParamsButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.inferParamsButtonLabel', {
    defaultMessage: 'Infer parameters'
  }),
  noParamsMessage: _i18n.i18n.translate('xpack.onechat.tools.newTool.noParamsMessage', {
    defaultMessage: 'Add parameters or infer them from your ES|QL query.'
  }),
  optionalFieldLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.optionalFieldLabel', {
    defaultMessage: 'Optional'
  }),
  documentationLinkLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.documentationLinkLabel', {
    defaultMessage: 'Documentation'
  }),
  systemReferences: {
    documentation: {
      title: _i18n.i18n.translate('xpack.onechat.tools.newTool.systemReferences.title', {
        defaultMessage: 'Details'
      }),
      description: _i18n.i18n.translate('xpack.onechat.tools.newTool.systemReferences.description', {
        defaultMessage: "Define the tool's ID and describe how it behaves."
      }),
      toolBasicsDocumentationLink: _i18n.i18n.translate('xpack.onechat.tools.newTool.toolBasics.documentationLink', {
        defaultMessage: 'Tool basics'
      })
    },
    form: {
      toolId: {
        label: _i18n.i18n.translate('xpack.onechat.tools.newTool.form.toolIdLabel', {
          defaultMessage: 'Tool ID'
        }),
        helpText: _i18n.i18n.translate('xpack.onechat.tools.newTool.form.toolIdHelpText', {
          defaultMessage: 'Tool ID must start and end with a letter or number, and can only contain lowercase letters, numbers, dots, and underscores.'
        })
      },
      description: {
        label: _i18n.i18n.translate('xpack.onechat.tools.newTool.form.descriptionLabel', {
          defaultMessage: 'Description'
        })
      }
    }
  },
  toolLabels: {
    documentation: {
      title: _i18n.i18n.translate('xpack.onechat.tools.newTool.labels.title', {
        defaultMessage: 'Labels'
      }),
      description: _i18n.i18n.translate('xpack.onechat.tools.newTool.labels.description', {
        defaultMessage: 'Add labels for filtering and organizing tools.'
      }),
      documentationLink: _i18n.i18n.translate('xpack.onechat.tools.newTool.labels.toolLabelsDocumentationLink', {
        defaultMessage: 'Tool labels'
      })
    },
    form: {
      label: _i18n.i18n.translate('xpack.onechat.tools.newTool.labels.formLabel', {
        defaultMessage: 'Labels'
      }),
      placeholder: _i18n.i18n.translate('xpack.onechat.tools.newTool.labels.formPlaceholder', {
        defaultMessage: 'Add or create labels'
      })
    }
  },
  configuration: {
    documentation: {
      title: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.title', {
        defaultMessage: 'Type'
      }),
      description: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.description', {
        defaultMessage: "Set the tool's type and the parameters that control how it operates."
      }),
      documentationLink: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.documentationLink', {
        defaultMessage: 'Configuring a tool'
      })
    },
    form: {
      type: {
        label: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.type.label', {
          defaultMessage: 'Type'
        }),
        esqlOption: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.type.esqlOption', {
          defaultMessage: 'ES|QL'
        }),
        indexSearchOption: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.type.indexSearchOption', {
          defaultMessage: 'Index search'
        }),
        workflowOption: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.type.workflowOption', {
          defaultMessage: 'Workflow'
        }),
        mcpOption: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.type.mcpOption', {
          defaultMessage: 'MCP'
        })
      },
      indexSearch: {
        patternLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.patternLabel', {
          defaultMessage: 'Target pattern'
        }),
        defaultRowLimitLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.defaultRowLimitLabel', {
          defaultMessage: 'Row limit'
        }),
        defaultRowLimitHelpText: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.defaultRowLimitHelpText', {
          defaultMessage: 'Maximum number of rows to return from ES|QL queries.'
        }),
        customInstructionsLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.customInstructionsLabel', {
          defaultMessage: 'Custom instructions'
        }),
        customInstructionsHelpText: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.customInstructionsHelpText', {
          defaultMessage: 'Additional guidance for ES|QL query generation, such as field selection or limit logic.'
        }),
        customInstructionsPlaceholder: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.customInstructionsPlaceholder', {
          defaultMessage: 'e.g., "Always include timestamp field" '
        })
      },
      esql: {
        queryLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.esql.queryLabel', {
          defaultMessage: 'ES|QL Query'
        }),
        parametersLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.esql.parametersLabel', {
          defaultMessage: 'ES|QL Parameters'
        })
      },
      workflow: {
        workflowLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.workflow.workflowLabel', {
          defaultMessage: 'Workflow'
        }),
        waitForCompletionLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.workflow.waitForCompletionLabel', {
          defaultMessage: 'Workflow execution'
        }),
        waitForCompletionHelpText: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.workflow.waitForCompletionHelpText', {
          defaultMessage: 'If checked, the tool waits until the workflow completes (up to 120s) and returns the results. If unchecked, the workflow runs in the background and you can ask the agent to check the execution status.'
        }),
        waitForCompletionCheckboxLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.workflow.waitForCompletionCheckboxLabel', {
          defaultMessage: 'Wait until the workflow completes'
        })
      },
      mcp: {
        connectorLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.mcp.connectorLabel', {
          defaultMessage: 'MCP Server'
        }),
        mcpToolLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.mcp.mcpToolLabel', {
          defaultMessage: 'Tool'
        }),
        mcpToolFetchError: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.mcp.mcpToolFetchError', {
          defaultMessage: "We're unable to fetch tools from this MCP server. This is usually caused by a connection or configuration issue with the MCP connector."
        }),
        mcpToolDetailsTitle: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.mcp.mcpToolDetailsTitle', {
          defaultMessage: 'MCP Tool Details'
        }),
        addMcpServerButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.mcp.addMcpServerButtonLabel', {
          defaultMessage: 'Add a new MCP Server'
        }),
        bulkImportMcpToolsButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.mcp.bulkImportMcpToolsButtonLabel', {
          defaultMessage: 'Bulk import MCP Tools'
        }),
        mcpHealthStatusHealthy: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.mcp.mcpHealthStatusHealthy', {
          defaultMessage: 'Healthy'
        }),
        mcpHealthStatusError: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.mcp.mcpHealthStatusError', {
          defaultMessage: 'Error'
        }),
        mcpHealthStatusLoading: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.mcp.mcpHealthStatusLoading', {
          defaultMessage: 'Loading'
        })
      }
    }
  }
};