"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.McpToolsSelectionTableHeader = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireWildcard(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _i18n = require("../../../utils/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/bulk_import/mcp_tools_selection_table_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tableHeaderContainerStyles = ({
  euiTheme
}) => (0, _react.css)`
  margin-block-start: -${euiTheme.size.s};
`;
const tableHeaderStyles = (0, _react.css)`
  min-height: 24px;
`;
const tableHeaderSkeletonStyles = (0, _react.css)`
  display: inline-block;
  width: 200px;
`;
const tableHeaderButtonStyles = ({
  euiTheme
}) => (0, _react.css)`
  font-weight: ${euiTheme.font.weight.semiBold};
`;
const McpToolsSelectionTableHeader = exports.McpToolsSelectionTableHeader = /*#__PURE__*/(0, _react2.memo)(({
  isLoading,
  pageIndex,
  pageSize,
  totalCount,
  selectedCount,
  onSelectAll,
  onClearSelection
}) => {
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const closePopover = (0, _react2.useCallback)(() => {
    togglePopover(false);
  }, [togglePopover]);
  const handleSelectAll = (0, _react2.useCallback)(() => {
    onSelectAll();
    togglePopover(false);
  }, [onSelectAll, togglePopover]);
  const paginationStart = pageIndex * pageSize + 1;
  const paginationEnd = Math.min((pageIndex + 1) * pageSize, totalCount);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    css: tableHeaderContainerStyles,
    loadingContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
      css: tableHeaderSkeletonStyles,
      lines: 1,
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 25
      }
    }),
    loadedContent: totalCount > 0 ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      css: tableHeaderStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.tools.bulkImportMcp.sourceSection.tableSummary",
      defaultMessage: "Showing {start}-{end} of {total}",
      values: {
        start: /*#__PURE__*/_react2.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 30
          }
        }, paginationStart),
        end: /*#__PURE__*/_react2.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 28
          }
        }, paginationEnd),
        total: totalCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 19
      }
    }))), selectedCount > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "arrowDown",
        iconSide: "right",
        iconSize: "s",
        size: "xs",
        onClick: togglePopover,
        "data-test-subj": "bulkImportMcpToolsSelectionPopoverButton",
        css: tableHeaderButtonStyles,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 25
        }
      }, _i18n.labels.tools.bulkImportMcp.sourceSection.selectedCount(selectedCount)),
      isOpen: isPopoverOpen,
      closePopover: closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downLeft",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: [/*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
        key: "selectAll",
        icon: "pagesSelect",
        onClick: handleSelectAll,
        "data-test-subj": "bulkImportMcpToolsSelectAllButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 27
        }
      }, _i18n.labels.tools.selectAllToolsButtonLabel)],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 23
      }
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      iconSize: "s",
      size: "xs",
      color: "danger",
      onClick: onClearSelection,
      "data-test-subj": "bulkImportMcpToolsClearSelectionButton",
      css: tableHeaderButtonStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 21
      }
    }, _i18n.labels.tools.bulkImportMcp.sourceSection.clearSelection)))) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  });
});