"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.McpToolsSelectionTable = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("../../../utils/i18n");
var _truncate_at_sentence = require("../../../utils/truncate_at_sentence");
var _mcp_tools_selection_table_header = require("./mcp_tools_selection_table_header");
var _use_mcp_tools_search = require("./use_mcp_tools_search");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/bulk_import/mcp_tools_selection_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PAGE_SIZE = 10;
const PAGE_SIZE_OPTIONS = [10, 25, 50];
const tableContainerStyles = (isDisabled = false) => (0, _react.css)`
  ${isDisabled && `
    opacity: 0.5;
    pointer-events: none;
  `}
`;
const McpToolsSelectionTable = ({
  tools,
  selectedTools,
  onChange,
  isLoading,
  isError,
  isDisabled,
  disabledMessage
}) => {
  const [tablePageIndex, setTablePageIndex] = (0, _react2.useState)(0);
  const [tablePageSize, setTablePageSize] = (0, _react2.useState)(DEFAULT_PAGE_SIZE);

  // Track when "select all" is active to prevent the table's internal selection
  // mechanism from limiting selection to only the visible page items.
  // Using a ref to avoid stale closure issues in the selection change callback.
  const isSelectAllActiveRef = (0, _react2.useRef)(false);
  const {
    searchConfig,
    searchQuery,
    results: filteredTools
  } = (0, _use_mcp_tools_search.useMcpToolsSearch)({
    tools,
    isDisabled
  });

  // Reset page index when filtered results change
  (0, _react2.useEffect)(() => {
    setTablePageIndex(0);
  }, [filteredTools]);
  const selectedMcpTools = (0, _react2.useMemo)(() => {
    const selectedNames = new Set(selectedTools.map(tool => tool.name));
    return tools.filter(tool => selectedNames.has(tool.name));
  }, [tools, selectedTools]);
  const columns = (0, _react2.useMemo)(() => [{
    field: 'name',
    name: _i18n.labels.tools.bulkImportMcp.sourceSection.nameColumn,
    sortable: true,
    render: (name, tool) => {
      const shortDescription = tool.description ? (0, _truncate_at_sentence.truncateAtSentence)(tool.description) : undefined;
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHighlight, {
        search: searchQuery,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 21
        }
      }, name)))), shortDescription && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHighlight, {
        search: searchQuery,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 21
        }
      }, shortDescription))));
    }
  }], [searchQuery]);
  const handleSelectionChange = (0, _react2.useCallback)(newSelection => {
    // When "select all" is active, the table fires onSelectionChange twice:
    // once with all items, then again limiting to visible page items.
    // Ignore the second call that would reduce the selection.
    if (isSelectAllActiveRef.current && newSelection.length < tools.length) {
      isSelectAllActiveRef.current = false;
      return;
    }
    onChange(newSelection);
  }, [onChange, tools.length]);
  const handleClearSelection = (0, _react2.useCallback)(() => {
    onChange([]);
  }, [onChange]);
  const handleSelectAll = (0, _react2.useCallback)(() => {
    isSelectAllActiveRef.current = true;
    onChange([...tools]);
  }, [onChange, tools]);
  const selection = (0, _react2.useMemo)(() => ({
    selectable: () => !isDisabled,
    selectableMessage: () => '',
    onSelectionChange: handleSelectionChange,
    selected: selectedMcpTools
  }), [isDisabled, handleSelectionChange, selectedMcpTools]);
  const emptyMessage = (0, _react2.useMemo)(() => {
    if (isLoading) {
      return _i18n.labels.tools.bulkImportMcp.sourceSection.loadingToolsMessage;
    }
    if (isDisabled) {
      return disabledMessage !== null && disabledMessage !== void 0 ? disabledMessage : null;
    }
    if (searchQuery && tools.length > 0 && filteredTools.length === 0) {
      return _i18n.labels.tools.bulkImportMcp.sourceSection.noMatchingToolsMessage;
    }
    if (tools.length === 0) {
      return _i18n.labels.tools.bulkImportMcp.sourceSection.noToolsMessage;
    }
    return undefined;
  }, [isDisabled, isLoading, searchQuery, tools.length, filteredTools.length, disabledMessage]);
  const tableHeader = /*#__PURE__*/_react2.default.createElement(_mcp_tools_selection_table_header.McpToolsSelectionTableHeader, {
    isLoading: isLoading,
    pageIndex: tablePageIndex,
    pageSize: tablePageSize,
    totalCount: filteredTools.length,
    selectedCount: selectedMcpTools.length,
    onSelectAll: handleSelectAll,
    onClearSelection: handleClearSelection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "m",
    css: tableContainerStyles(isDisabled),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiInMemoryTable, {
    items: filteredTools,
    columns: columns,
    itemId: "name",
    selection: selection,
    search: searchConfig,
    onTableChange: ({
      page
    }) => {
      if (page) {
        setTablePageIndex(page.index);
        if (page.size !== tablePageSize) {
          setTablePageSize(page.size);
          setTablePageIndex(0);
        }
      }
    },
    pagination: {
      initialPageSize: DEFAULT_PAGE_SIZE,
      pageSizeOptions: PAGE_SIZE_OPTIONS,
      showPerPageOptions: true,
      pageIndex: tablePageIndex,
      pageSize: tablePageSize
    },
    sorting: {
      sort: {
        field: 'name',
        direction: 'asc'
      }
    },
    loading: isLoading,
    error: isError ? _i18n.labels.tools.bulkImportMcp.sourceSection.toolsErrorMessage : undefined,
    noItemsMessage: emptyMessage,
    tableCaption: _i18n.labels.tools.bulkImportMcp.sourceSection.tableCaption,
    childrenBetween: tableHeader,
    rowProps: item => ({
      'data-test-subj': `bulkImportMcpToolsTableRow-${item.name}`
    }),
    "data-test-subj": "bulkImportMcpToolsTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }));
};
exports.McpToolsSelectionTable = McpToolsSelectionTable;