"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkImportMcpTools = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _lodash = require("lodash");
var _reactHookForm = require("react-hook-form");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _common = require("../../../../common.styles");
var _i18n2 = require("../../../utils/i18n");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../utils/app_paths");
var _use_bulk_import_mcp_tools = require("../../../hooks/tools/use_bulk_import_mcp_tools");
var _use_toasts = require("../../../hooks/use_toasts");
var _bulk_import_mcp_tools_form = require("./bulk_import_mcp_tools_form");
var _zod_resolver = require("../../../utils/zod_resolver");
var _bulk_import_mcp_tool_form_validation = require("../form/validation/bulk_import_mcp_tool_form_validation");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/bulk_import/bulk_import_mcp_tools.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const headerStyles = ({
  euiTheme
}) => (0, _react2.css)`
  background-color: ${euiTheme.colors.backgroundBasePlain};
  border-block-end: none;
`;
const TECH_PREVIEW_LABEL = _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.techPreviewBadgeLabel', {
  defaultMessage: 'Technical preview'
});
const TECH_PREVIEW_DESCRIPTION = _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.techPreviewBadgeDescription', {
  defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
});
const bottomBarStyles = ({
  euiTheme
}) => (0, _react2.css)`
  z-index: ${euiTheme.levels.header};
`;
const defaultFormValues = {
  connectorId: '',
  tools: [],
  namespace: '',
  labels: []
};
const BulkImportMcpTools = () => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    application: {
      navigateToUrl
    },
    overlays: {
      openConfirm
    },
    http,
    appParams: {
      history
    }
  } = services;
  const {
    navigateToOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    addSuccessToast,
    addErrorToast
  } = (0, _use_toasts.useToasts)();
  const [isCancelling, setIsCancelling] = (0, _react.useState)(false);
  const formId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'bulkImportMcpToolsForm'
  });
  const bulkImportMcpToolFormValidationSchema = (0, _bulk_import_mcp_tool_form_validation.useBulkImportMcpToolFormValidationSchema)();
  const form = (0, _reactHookForm.useForm)({
    defaultValues: defaultFormValues,
    mode: 'onBlur',
    resolver: (0, _zod_resolver.zodResolver)(bulkImportMcpToolFormValidationSchema)
  });
  const {
    control,
    formState
  } = form;
  const {
    errors,
    isSubmitting,
    isDirty,
    isSubmitSuccessful
  } = formState;
  const {
    mutateAsync: bulkImportTools
  } = (0, _use_bulk_import_mcp_tools.useBulkImportMcpTools)();
  const selectedTools = (0, _reactHookForm.useWatch)({
    control,
    name: 'tools'
  });
  const hasErrors = Object.keys(errors).length > 0;
  const hasSelectedTools = selectedTools.length > 0;
  const isSubmitDisabled = !hasSelectedTools || hasErrors || isSubmitting;
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    hasUnsavedChanges: isDirty && !isSubmitSuccessful && !isCancelling,
    history,
    http,
    navigateToUrl,
    openConfirm,
    shouldPromptOnReplace: false
  });
  const deferNavigateToOnechatUrl = (0, _react.useCallback)((...args) => {
    (0, _lodash.defer)(() => navigateToOnechatUrl(...args));
  }, [navigateToOnechatUrl]);
  const handleCancel = (0, _react.useCallback)(() => {
    setIsCancelling(true);
    deferNavigateToOnechatUrl(_app_paths.appPaths.tools.list);
  }, [deferNavigateToOnechatUrl]);
  const handleImport = (0, _react.useCallback)(async data => {
    const {
      connectorId,
      tools,
      namespace,
      labels: tags
    } = data;
    try {
      const result = await bulkImportTools({
        connectorId,
        tools,
        namespace,
        tags,
        skipExisting: true
      });
      addSuccessToast({
        title: _i18n2.labels.tools.bulkImportMcp.importSuccessToast(result.summary.created)
      });
      deferNavigateToOnechatUrl(_app_paths.appPaths.tools.list);
    } catch (error) {
      addErrorToast({
        title: _i18n2.labels.tools.bulkImportMcp.importErrorToast,
        text: error instanceof Error ? error.message : undefined
      });
    }
  }, [bulkImportTools, deferNavigateToOnechatUrl, addSuccessToast, addErrorToast]);
  const renderImportToolsButton = ({
    size = 's',
    testSubj
  } = {}) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: size,
      type: "submit",
      form: formId,
      fill: true,
      iconType: "download",
      isLoading: isSubmitting,
      disabled: isSubmitDisabled,
      "data-test-subj": testSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 7
      }
    }, _i18n2.labels.tools.bulkImportMcp.importToolsButton);
  };
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, form, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    "data-test-subj": "agentBuilderBulkImportMcpToolsPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 15
      }
    }, _i18n2.labels.tools.bulkImportMcp.title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: TECH_PREVIEW_LABEL,
      tooltipContent: TECH_PREVIEW_DESCRIPTION,
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 17
      }
    }))),
    description: _i18n2.labels.tools.bulkImportMcp.description,
    rightSideItems: [renderImportToolsButton({
      size: 'm',
      testSubj: 'bulkImportMcpToolsImportButton'
    })],
    css: headerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_bulk_import_mcp_tools_form.BulkImportMcpToolsForm, {
    formId: formId,
    onSubmit: handleImport,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, {
    css: bottomBarStyles,
    paddingSize: "m",
    restrictWidth: false,
    position: "fixed",
    usePortal: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    css: _common.pushFlyoutPaddingStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "cross",
    color: "text",
    onClick: handleCancel,
    "data-test-subj": "bulkImportMcpToolsCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }, _i18n2.labels.tools.bulkImportMcp.cancelButton)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  }, renderImportToolsButton())))));
};
exports.BulkImportMcpTools = BulkImportMcpTools;