"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolResultDisplay = void 0;
var _tool_result = require("@kbn/onechat-common/tools/tool_result");
var _react = _interopRequireDefault(require("react"));
var _tabular_data_result_step = require("./tabular_data_result_step");
var _other_result_step = require("./other_result_step");
var _query_result_step = require("./query_result_step");
var _error_result_step = require("./error_result_step");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/steps/tool_result_display.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ToolResultDisplay = ({
  toolResult
}) => {
  switch (toolResult.type) {
    case _tool_result.ToolResultType.query:
      return /*#__PURE__*/_react.default.createElement(_query_result_step.QueryResultStep, {
        result: toolResult,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 23,
          columnNumber: 14
        }
      });
    case _tool_result.ToolResultType.tabularData:
      return /*#__PURE__*/_react.default.createElement(_tabular_data_result_step.TabularDataResultStep, {
        result: toolResult,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 25,
          columnNumber: 14
        }
      });
    case _tool_result.ToolResultType.error:
      return /*#__PURE__*/_react.default.createElement(_error_result_step.ErrorResultStep, {
        result: toolResult,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 27,
          columnNumber: 14
        }
      });
    default:
      // Other results
      // Also showing Resource results as Other results for now as JSON blobs
      return /*#__PURE__*/_react.default.createElement(_other_result_step.OtherResultStep, {
        result: toolResult,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 14
        }
      });
  }
};
exports.ToolResultDisplay = ToolResultDisplay;