"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundThinking = void 0;
var _react = _interopRequireWildcard(require("react"));
var _onechatCommon = require("@kbn/onechat-common");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _round_thinking_title = require("./round_thinking_title");
var _round_thinking_panel = require("./round_thinking_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/round_thinking.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fadeIn = (0, _react2.keyframes)`
  from {
    opacity: 0;
    transform: translate(-8px, -8px);
  }
  to {
    opacity: 1;
    transform: translate(0, 0);
  }
`;
const RoundThinking = ({
  steps,
  isLoading,
  rawRound
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [showThinkingPanel, setShowThinkingPanel] = (0, _react.useState)(false);
  const toggleThinkingPanel = () => {
    setShowThinkingPanel(!showThinkingPanel);
  };
  const fadeInStyles = (0, _react2.css)`
    animation: ${fadeIn} ${euiTheme.animation.fast} ease-out;
  `;
  if (showThinkingPanel) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      css: fadeInStyles,
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_round_thinking_panel.RoundThinkingPanel, {
      steps: steps,
      isLoading: isLoading,
      rawRound: rawRound,
      onClose: toggleThinkingPanel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    })));
  }
  const hasSteps = steps.length > 0 && steps.some(step => !(0, _onechatCommon.isReasoningStep)(step) || step.transient !== true);
  return /*#__PURE__*/_react.default.createElement(_round_thinking_title.RoundThinkingTitle, {
    isLoading: isLoading,
    hasSteps: hasSteps,
    onShow: toggleThinkingPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
};
exports.RoundThinking = RoundThinking;