"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputOutputTokensDisplay = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/input_output_tokens_display.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const tooltipLabels = {
  input: _i18n.i18n.translate('xpack.onechat.tokenDisplay.inputTooltip', {
    defaultMessage: 'Tokens sent to the model'
  }),
  output: _i18n.i18n.translate('xpack.onechat.tokenDisplay.outputTooltip', {
    defaultMessage: 'Tokens generated by the model'
  })
};
const TokenDisplay = ({
  type,
  value
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: tooltipLabels[type],
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  alignItems: "center",
  gutterSize: "s",
  responsive: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  color: "subdued",
  type: type === 'input' ? 'sortUp' : 'sortDown',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.onechat.tokenDisplay.tokenUsage",
  defaultMessage: "{value} tokens",
  values: {
    value: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 20
      }
    })
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 9
  }
}))));
const InputOutputTokensDisplay = ({
  modelUsage
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  alignItems: "center",
  gutterSize: "s",
  responsive: false,
  css: (0, _react2.css)`
      flex-grow: 0;
    `,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(TokenDisplay, {
  type: "input",
  value: modelUsage.input_tokens,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(TokenDisplay, {
  type: "output",
  value: modelUsage.output_tokens,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 5
  }
}));
exports.InputOutputTokensDisplay = InputOutputTokensDisplay;