"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundResponse = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _streaming_text = require("./streaming_text");
var _chat_message_text = require("./chat_message_text");
var _round_response_actions = require("./round_response_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_response/round_response.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RoundResponse = ({
  hasError,
  response: {
    message
  },
  steps,
  isLoading
}) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "m",
  "aria-label": _i18n.i18n.translate('xpack.onechat.round.assistantResponse', {
    defaultMessage: 'Assistant response'
  }),
  "data-test-subj": "agentBuilderRoundResponse",
  css: (0, _react.css)`
      position: relative;
    `,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 3
  }
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 5
  }
}, isLoading ? /*#__PURE__*/_react2.default.createElement(_streaming_text.StreamingText, {
  content: message,
  steps: steps,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 9
  }
}) : /*#__PURE__*/_react2.default.createElement(_chat_message_text.ChatMessageText, {
  content: message,
  steps: steps,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 9
  }
})), !isLoading && !hasError && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 7
  }
}, /*#__PURE__*/_react2.default.createElement(_round_response_actions.RoundResponseActions, {
  content: message,
  isVisible: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 9
  }
})));
exports.RoundResponse = RoundResponse;