"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationInput = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _use_conversation_id = require("../../../context/conversation/use_conversation_id");
var _send_message_context = require("../../../context/send_message/send_message_context");
var _use_agents = require("../../../hooks/agents/use_agents");
var _use_validate_agent_id = require("../../../hooks/agents/use_validate_agent_id");
var _use_is_sending_message = require("../../../hooks/use_is_sending_message");
var _use_conversation = require("../../../hooks/use_conversation");
var _message_editor = require("./message_editor");
var _input_actions = require("./input_actions");
var _common = require("../../../../common.styles");
var _conversation_context = require("../../../context/conversation/conversation_context");
var _attachment_pills_row = require("./attachment_pills_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/conversation_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INPUT_MIN_HEIGHT = '150px';
const useInputBorderStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.css)`
    border: ${euiTheme.border.thin};
    ${_common.borderRadiusXlStyles}
    border-color: ${euiTheme.colors.borderBaseSubdued};
    &:focus-within[aria-disabled='false'] {
      border-color: ${euiTheme.colors.primary};
    }
  `;
};
const useInputShadowStyles = () => {
  return (0, _react.css)`
    ${(0, _eui.useEuiShadow)('s')}
    &:hover {
      ${(0, _eui.useEuiShadowHover)('s')}
    }
    &:focus-within[aria-disabled='false'] {
      ${(0, _eui.useEuiShadow)('xl')}
      :hover {
        ${(0, _eui.useEuiShadowHover)('xl')}
      }
    }
  `;
};
const containerAriaLabel = _i18n.i18n.translate('xpack.onechat.conversationInput.container.label', {
  defaultMessage: 'Message input form'
});
const InputContainer = ({
  children,
  isDisabled,
  isCollapsed
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const inputContainerStyles = (0, _react.css)`
    width: 100%;
    min-height: ${isCollapsed ? '0' : INPUT_MIN_HEIGHT};
    padding: ${euiTheme.size.base};
    flex-grow: 0;
    transition: box-shadow 250ms, border-color 250ms, min-height 250ms ease-out;
    background-color: ${euiTheme.colors.backgroundBasePlain};

    ${useInputBorderStyles()}
    ${useInputShadowStyles()}

    &[aria-disabled='true'] {
      background-color: ${euiTheme.colors.backgroundBaseDisabled};
    }
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: inputContainerStyles,
    direction: "column",
    gutterSize: "s",
    responsive: false,
    alignItems: "stretch",
    justifyContent: "center",
    "data-test-subj": "agentBuilderConversationInputForm",
    "aria-label": containerAriaLabel,
    "aria-disabled": isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, children);
};
const disabledPlaceholder = agentId => _i18n.i18n.translate('xpack.onechat.conversationInput.textArea.disabledPlaceholder', {
  defaultMessage: 'Agent "{agentId}" has been deleted. Please start a new conversation.',
  values: {
    agentId
  }
});
const enabledPlaceholder = _i18n.i18n.translate('xpack.onechat.conversationInput.textArea.enabledPlaceholder', {
  defaultMessage: 'Ask anything'
});
const ConversationInput = ({
  onSubmit
}) => {
  const isSendingMessage = (0, _use_is_sending_message.useIsSendingMessage)();
  const {
    sendMessage,
    pendingMessage,
    error
  } = (0, _send_message_context.useSendMessage)();
  const {
    isFetched
  } = (0, _use_agents.useOnechatAgents)();
  const agentId = (0, _use_conversation.useAgentId)();
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const messageEditor = (0, _message_editor.useMessageEditor)();
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  const {
    attachments,
    initialMessage,
    autoSendInitialMessage,
    resetInitialMessage
  } = (0, _conversation_context.useConversationContext)();
  const validateAgentId = (0, _use_validate_agent_id.useValidateAgentId)();
  const isAgentIdValid = validateAgentId(agentId);
  const isInputDisabled = !isAgentIdValid && isFetched && Boolean(agentId);
  const isSubmitDisabled = messageEditor.isEmpty || isSendingMessage || !isAgentIdValid;
  const placeholder = isInputDisabled ? disabledPlaceholder(agentId) : enabledPlaceholder;
  const editorContainerStyles = (0, _react.css)`
    display: flex;
    flex-direction: column;
    height: 100%;
  `;
  // Hide attachments if there's an error from current round or if message has been just sent
  const shouldHideAttachments = Boolean(error) || isSendingMessage;
  const shouldCollapseInput = isSendingMessage || hasActiveConversation;
  const visibleAttachments = (0, _react2.useMemo)(() => {
    if (!attachments || shouldHideAttachments) return [];
    return attachments.filter(attachment => !attachment.hidden).map((attachment, idx) => {
      var _attachment$id;
      return {
        ...attachment,
        id: (_attachment$id = attachment.id) !== null && _attachment$id !== void 0 ? _attachment$id : `attachment-${idx}`
      };
    });
  }, [attachments, shouldHideAttachments]);
  const isNewConversation = !conversationId;
  // Set initial message in input when {autoSendInitialMessage} is false and {initialMessage} is provided
  (0, _react2.useEffect)(() => {
    if (initialMessage && !autoSendInitialMessage && isNewConversation) {
      messageEditor.setContent(initialMessage);
      messageEditor.focus();
      resetInitialMessage === null || resetInitialMessage === void 0 ? void 0 : resetInitialMessage(); // Reset the initial message to avoid sending it again
    }
  }, [initialMessage, autoSendInitialMessage, isNewConversation, messageEditor, resetInitialMessage]);

  // Auto-focus when conversation changes
  (0, _react2.useEffect)(() => {
    const timeoutId = setTimeout(() => {
      messageEditor.focus();
    }, 200);
    return () => {
      clearTimeout(timeoutId);
    };
  }, [conversationId, messageEditor]);
  const handleSubmit = () => {
    if (isSubmitDisabled) {
      return;
    }
    const content = messageEditor.getContent();
    sendMessage({
      message: content
    });
    messageEditor.clear();
    onSubmit === null || onSubmit === void 0 ? void 0 : onSubmit();
  };
  return /*#__PURE__*/_react2.default.createElement(InputContainer, {
    isDisabled: isInputDisabled,
    isCollapsed: shouldCollapseInput,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 5
    }
  }, visibleAttachments.length > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_attachment_pills_row.AttachmentPillsRow, {
    attachments: visibleAttachments,
    removable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: editorContainerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_message_editor.MessageEditor, {
    messageEditor: messageEditor,
    onSubmit: handleSubmit,
    disabled: isInputDisabled,
    placeholder: placeholder,
    "data-test-subj": "agentBuilderConversationInputEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  })), !isInputDisabled && /*#__PURE__*/_react2.default.createElement(_input_actions.InputActions, {
    onSubmit: handleSubmit,
    isSubmitDisabled: isSubmitDisabled,
    resetToPendingMessage: () => {
      if (pendingMessage) {
        messageEditor.setContent(pendingMessage);
      }
    },
    agentId: agentId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 9
    }
  }));
};
exports.ConversationInput = ConversationInput;