"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttachmentPill = void 0;
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_onechat_service = require("../../../hooks/use_onechat_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/attachment_pill.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const removeAriaLabel = _i18n.i18n.translate('xpack.onechat.attachmentPill.removeAriaLabel', {
  defaultMessage: 'Remove attachment'
});
const DEFAULT_ICON = 'document';
const AttachmentPill = ({
  attachment,
  onRemoveAttachment
}) => {
  var _uiDefinition$getLabe, _uiDefinition$getIcon, _uiDefinition$getIcon2;
  const {
    attachmentsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const uiDefinition = attachmentsService.getAttachmentUiDefinition(attachment.type);
  const [isHovered, setIsHovered] = (0, _react.useState)(false);
  const displayName = (_uiDefinition$getLabe = uiDefinition === null || uiDefinition === void 0 ? void 0 : uiDefinition.getLabel(attachment)) !== null && _uiDefinition$getLabe !== void 0 ? _uiDefinition$getLabe : attachment.type;
  const canRemoveAttachment = Boolean(onRemoveAttachment);
  const iconType = (_uiDefinition$getIcon = uiDefinition === null || uiDefinition === void 0 ? void 0 : (_uiDefinition$getIcon2 = uiDefinition.getIcon) === null || _uiDefinition$getIcon2 === void 0 ? void 0 : _uiDefinition$getIcon2.call(uiDefinition)) !== null && _uiDefinition$getIcon !== void 0 ? _uiDefinition$getIcon : DEFAULT_ICON;
  const iconContainerStyles = (0, _css.css)`
    display: flex;
    align-items: center;
    justify-content: center;
    width: ${euiTheme.size.xl};
    height: ${euiTheme.size.xl};
    border-radius: ${euiTheme.border.radius.small};
    background-color: ${euiTheme.colors.backgroundBasePrimary};
  `;
  const titleStyles = (0, _css.css)`
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
    text-overflow: ellipsis;
    word-break: break-word;
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    color: "subdued",
    paddingSize: "s",
    css: (0, _css.css)`
        max-width: 200px;
        border: ${euiTheme.border.width.thin} solid ${euiTheme.colors.darkShade};
      `,
    onMouseEnter: () => setIsHovered(true),
    onMouseLeave: () => setIsHovered(false),
    "data-test-subj": `onechatAttachmentPill-${attachment.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: iconContainerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "m",
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: titleStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, displayName))), canRemoveAttachment && isHovered && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    size: "xs",
    color: "text",
    "aria-label": removeAriaLabel,
    onClick: onRemoveAttachment,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }))));
};
exports.AttachmentPill = AttachmentPill;