"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationRightActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _conversation_context = require("../../../context/conversation/conversation_context");
var _more_actions_button = require("./more_actions_button");
var _close_docked_view_button = require("./close_docked_view_button");
var _agent_builder_tour_context = require("../../../context/agent_builder_tour_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_header/conversation_actions_right.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  container: _i18n.i18n.translate('xpack.onechat.conversationActions.container', {
    defaultMessage: 'Conversation actions'
  })
};
const ConversationRightActions = ({
  onClose,
  onRenameConversation
}) => {
  const {
    isEmbeddedContext
  } = (0, _conversation_context.useConversationContext)();
  const {
    getStepProps
  } = (0, _agent_builder_tour_context.useAgentBuilderTour)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    alignItems: "center",
    "aria-label": labels.container,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, (0, _extends2.default)({}, getStepProps(_agent_builder_tour_context.TourStep.ConversationActions), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_more_actions_button.MoreActionsButton, {
    onRenameConversation: onRenameConversation,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  })), isEmbeddedContext ? /*#__PURE__*/_react.default.createElement(_close_docked_view_button.CloseDockedViewButton, {
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 28
    }
  }) : null);
};
exports.ConversationRightActions = ConversationRightActions;