"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentAvatar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _common = require("../../../common.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/common/agent_avatar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Icon size should be one size larger than the avatar size
const getIconSize = ({
  size
}) => {
  switch (size) {
    case 's':
      return 'm';
    case 'm':
      return 'l';
    case 'l':
      return 'xl';
    case 'xl':
      return 'xxl';
    default:
      return undefined;
  }
};
const AgentAvatar = props => {
  var _props$color;
  const {
    size,
    shape = 'circle'
  } = props;
  const {
    name,
    symbol,
    color: colorProp,
    readonly,
    icon
  } = 'agent' in props && props.agent ? {
    name: props.agent.name,
    symbol: props.agent.avatar_symbol,
    // Agent color can be overriden
    color: (_props$color = props.color) !== null && _props$color !== void 0 ? _props$color : props.agent.avatar_color,
    readonly: props.agent.readonly,
    icon: props.agent.avatar_icon
  } : {
    name: props.name,
    symbol: props.symbol,
    color: props.color,
    readonly: false
  };
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const color = colorProp === 'subdued' ? euiTheme.colors.backgroundBaseSubdued : colorProp;
  const hasBackground = Boolean(color);
  const isBuiltIn = readonly;
  const shouldUseIcon = isBuiltIn && !symbol;
  if (shouldUseIcon) {
    const iconType = icon !== null && icon !== void 0 ? icon : 'logoElastic';
    const iconSize = getIconSize({
      size
    });
    if (hasBackground) {
      const panelStyles = (0, _react2.css)`
        background-color: ${color};
        ${_common.roundedBorderRadiusStyles}
      `;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasBorder: false,
        hasShadow: false,
        css: panelStyles,
        paddingSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: iconType,
        size: iconSize,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: iconType,
      size: iconSize,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 12
      }
    });
  }
  let type;
  if (shape === 'circle') {
    type = 'user';
  } else if (shape === 'square') {
    type = 'space';
  }
  const avatarStyles = shape === 'square' && _common.roundedBorderRadiusStyles;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    size: size,
    name: name,
    initials: symbol,
    type: type,
    color: color,
    css: avatarStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  });
};
exports.AgentAvatar = AgentAvatar;