"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromptLayout = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/access/prompts/prompt_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const defaultPromptStyles = (0, _react.css)`
  .euiEmptyPrompt__main {
    width: 740px;
  }
`;
const PromptLayout = ({
  imageSrc,
  title,
  subtitle,
  primaryButton,
  secondaryButton,
  variant = 'default'
}) => {
  const actions = [primaryButton, ...(secondaryButton ? [secondaryButton] : [])];
  const isEmbeddable = variant === 'embeddable';
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    css: isEmbeddable ? undefined : defaultPromptStyles,
    hasShadow: !isEmbeddable,
    color: isEmbeddable ? 'transparent' : 'plain',
    icon: /*#__PURE__*/_react2.default.createElement(_eui.EuiImage, {
      src: imageSrc,
      alt: "",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 13
      }
    }),
    title: /*#__PURE__*/_react2.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 14
      }
    }, title),
    body: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      color: "subdued",
      textAlign: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 9
      }
    }, subtitle),
    actions: actions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
};
exports.PromptLayout = PromptLayout;