"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaletteLegends = PaletteLegends;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _core_vital_item = require("./core_vital_item");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/overview/components/sections/ux/core_web_vitals/palette_legends.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PaletteLegend = (0, _styledComponents.default)(_eui.EuiHealth)`
  &:hover {
    cursor: pointer;
    text-decoration: underline;
  }
`;
const StyledSpan = _styledComponents.default.span`
  &:hover {
    background-color: ${props => props.darkMode ? _uiTheme.euiDarkVars.euiColorLightestShade : _uiTheme.euiLightVars.euiColorLightestShade};
  }
`;
function PaletteLegends({
  ranks,
  title,
  onItemHover,
  thresholds,
  isCls
}) {
  const darkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const palette = (0, _eui.euiPaletteForStatus)(3);
  const labels = [_translations.LEGEND_GOOD_LABEL, _translations.LEGEND_NEEDS_IMPROVEMENT_LABEL, _translations.LEGEND_POOR_LABEL];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, palette.map((color, ind) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: ind,
    grow: false,
    onMouseEnter: () => {
      onItemHover(ind);
    },
    onMouseLeave: () => {
      onItemHover(null);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (0, _core_vital_item.getCoreVitalTooltipMessage)(thresholds, ind, title, ranks[ind], isCls),
    position: "bottom",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(StyledSpan, {
    darkMode: darkMode,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(PaletteLegend, {
    color: color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": `${labels[ind]}-${ranks === null || ranks === void 0 ? void 0 : ranks[ind]}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.ux.coreVitals.paletteLegend.rankPercentage",
    defaultMessage: "{labelsInd} ({ranksInd}%)",
    values: {
      labelsInd: labels[ind],
      ranksInd: ranks === null || ranks === void 0 ? void 0 : ranks[ind]
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 19
    }
  }))))))));
}