"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesTableFilers = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRulesTableFilers = ({
  urlStateStorage,
  setRefresh
}) => {
  const {
    lastResponse,
    params,
    search,
    status,
    type
  } = urlStateStorage.get('_a') || {
    lastResponse: [],
    params: {},
    search: '',
    status: [],
    type: []
  };
  const [stateLastResponse, setLastResponse] = (0, _react.useState)(lastResponse);
  const [stateParams, setParams] = (0, _react.useState)(params);
  const [stateSearch, setSearch] = (0, _react.useState)(search);
  const [stateStatus, setStatus] = (0, _react.useState)(status);
  const [stateType, setType] = (0, _react.useState)(type);
  const [ruleConditionsFlyoutOpen, setRuleConditionsFlyoutOpen] = (0, _react.useState)(false);
  const [ruleIdToEdit, setRuleIdToEdit] = (0, _react.useState)();
  const handleStatusFilterChange = newStatus => {
    setStatus(newStatus);
    urlStateStorage.set('_a', {
      lastResponse,
      params,
      search,
      status: newStatus,
      type
    });
  };
  const handleLastRunOutcomeFilterChange = newLastResponse => {
    setRefresh(new Date());
    setLastResponse(newLastResponse);
    urlStateStorage.set('_a', {
      lastResponse: newLastResponse,
      params,
      search,
      status,
      type
    });
  };
  const handleTypeFilterChange = newType => {
    setType(newType);
    urlStateStorage.set('_a', {
      lastResponse,
      params,
      search,
      status,
      type: newType
    });
  };
  const handleSearchFilterChange = newSearch => {
    setSearch(newSearch);
    urlStateStorage.set('_a', {
      lastResponse,
      params,
      search: newSearch,
      status,
      type
    });
  };
  const handleRuleParamFilterChange = newParams => {
    setParams(newParams);
    urlStateStorage.set('_a', {
      lastResponse,
      params: newParams,
      search,
      status,
      type
    });
  };
  const navigateToEditRuleForm = ruleId => {
    setRuleIdToEdit(ruleId);
    setRuleConditionsFlyoutOpen(true);
  };
  return {
    stateLastResponse,
    stateParams,
    stateSearch,
    stateStatus,
    stateType,
    ruleConditionsFlyoutOpen,
    ruleIdToEdit,
    handleStatusFilterChange,
    handleLastRunOutcomeFilterChange,
    handleTypeFilterChange,
    handleSearchFilterChange,
    handleRuleParamFilterChange,
    setRuleIdToEdit,
    navigateToEditRuleForm,
    setRuleConditionsFlyoutOpen
  };
};
exports.useRulesTableFilers = useRulesTableFilers;