"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCaseActions = void 0;
var _react = require("react");
var _common = require("@kbn/cases-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCaseActions = ({
  alerts,
  onAddToCase,
  services
}) => {
  const {
    cases
  } = services;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onAddToExistingCase = (0, _react.useCallback)(() => {
    onAddToCase === null || onAddToCase === void 0 ? void 0 : onAddToCase({
      isNewCase: false
    });
  }, [onAddToCase]);
  const onAddToNewCase = (0, _react.useCallback)(() => {
    onAddToCase === null || onAddToCase === void 0 ? void 0 : onAddToCase({
      isNewCase: true
    });
  }, [onAddToCase]);
  const selectCaseModal = cases === null || cases === void 0 ? void 0 : cases.hooks.useCasesAddToExistingCaseModal({
    onSuccess: onAddToExistingCase
  });
  function getCaseAttachments() {
    return alerts.map(alert => {
      var _alert$_id, _alert$_index, _cases$helpers$getRul, _alert$_id2, _alert$_index2, _Object$entries$reduc;
      return {
        alertId: (_alert$_id = alert === null || alert === void 0 ? void 0 : alert._id) !== null && _alert$_id !== void 0 ? _alert$_id : '',
        index: (_alert$_index = alert === null || alert === void 0 ? void 0 : alert._index) !== null && _alert$_index !== void 0 ? _alert$_index : '',
        type: _common.AttachmentType.alert,
        rule: (_cases$helpers$getRul = cases === null || cases === void 0 ? void 0 : cases.helpers.getRuleIdFromEvent({
          ecs: {
            _id: (_alert$_id2 = alert === null || alert === void 0 ? void 0 : alert._id) !== null && _alert$_id2 !== void 0 ? _alert$_id2 : '',
            _index: (_alert$_index2 = alert === null || alert === void 0 ? void 0 : alert._index) !== null && _alert$_index2 !== void 0 ? _alert$_index2 : ''
          },
          data: (_Object$entries$reduc = Object.entries(alert !== null && alert !== void 0 ? alert : {}).reduce((acc, [field, value]) => [...acc, {
            field,
            value: value
          }], [])) !== null && _Object$entries$reduc !== void 0 ? _Object$entries$reduc : []
        })) !== null && _cases$helpers$getRul !== void 0 ? _cases$helpers$getRul : {
          id: '',
          name: ''
        }
      };
    });
  }
  const createCaseFlyout = cases === null || cases === void 0 ? void 0 : cases.hooks.useCasesAddToNewCaseFlyout({
    onSuccess: onAddToNewCase
  });
  const closeActionsPopover = () => {
    setIsPopoverOpen(false);
  };
  const handleAddToNewCaseClick = () => {
    createCaseFlyout === null || createCaseFlyout === void 0 ? void 0 : createCaseFlyout.open({
      attachments: getCaseAttachments()
    });
    closeActionsPopover();
  };
  const handleAddToExistingCaseClick = () => {
    selectCaseModal === null || selectCaseModal === void 0 ? void 0 : selectCaseModal.open({
      getAttachments: () => getCaseAttachments()
    });
    closeActionsPopover();
  };
  return {
    isPopoverOpen,
    setIsPopoverOpen,
    handleAddToExistingCaseClick,
    handleAddToNewCaseClick
  };
};
exports.useCaseActions = useCaseActions;