"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlowBreadcrumb = useFlowBreadcrumb;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFlowBreadcrumb(breadcrumb) {
  (0, _public.useBreadcrumbs)(breadcrumb !== null ? [breadcrumb] : [], {
    app: {
      id: 'observabilityOnboarding',
      label: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.breadcrumbs.addDataLabel', {
        defaultMessage: 'Add Data'
      })
    },
    absoluteProjectStyleBreadcrumbs: false
  });
}