"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPaddedAlertTimeRange = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPaddedAlertTimeRange = (alertStart, alertEnd, lookBackWindow) => {
  const alertDuration = _moment.default.duration((0, _moment.default)(alertEnd).diff((0, _moment.default)(alertStart)));
  const now = (0, _moment.default)().toISOString();

  // If alert duration is less than 160 min, we use 20 minute buffer
  // Otherwise, we use 8 times alert duration
  const defaultDurationMs = alertDuration.asMinutes() < 160 ? _moment.default.duration(20, 'minutes').asMilliseconds() : alertDuration.asMilliseconds() / 8;
  // To ensure the alert time range at least covers 20 times lookback window,
  // we compare lookBackDurationMs and defaultDurationMs to use any of those that is longer
  const lookBackDurationMs = lookBackWindow && _moment.default.duration(lookBackWindow.size * 20, lookBackWindow.unit).asMilliseconds();
  const durationMs = lookBackDurationMs && lookBackDurationMs - defaultDurationMs > 0 ? lookBackDurationMs : defaultDurationMs;
  const from = (0, _moment.default)(alertStart).subtract(durationMs, 'millisecond').toISOString();
  const to = alertEnd && (0, _moment.default)(alertEnd).add(durationMs, 'millisecond').isBefore(now) ? (0, _moment.default)(alertEnd).add(durationMs, 'millisecond').toISOString() : now;
  return {
    from,
    to
  };
};
exports.getPaddedAlertTimeRange = getPaddedAlertTimeRange;