"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addIndexWriteBlock = addIndexWriteBlock;
exports.isKnowledgeBaseIndexWriteBlocked = isKnowledgeBaseIndexWriteBlocked;
exports.removeIndexWriteBlock = removeIndexWriteBlock;
var _elasticsearch = require("@elastic/elasticsearch");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function addIndexWriteBlock({
  esClient,
  index
}) {
  await esClient.asInternalUser.indices.addBlock({
    index,
    block: 'write'
  });
}
function removeIndexWriteBlock({
  esClient,
  index
}) {
  return esClient.asInternalUser.indices.putSettings({
    index,
    body: {
      'index.blocks.write': false
    }
  });
}
function isKnowledgeBaseIndexWriteBlocked(error) {
  return error instanceof _elasticsearch.errors.ResponseError && error.message.includes(`cluster_block_exception`) && error.message.includes(_.resourceNames.writeIndexAlias.kb);
}