"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentBuilderOptIn = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _public = require("@kbn/ai-assistant-management-plugin/public");
var _use_kibana = require("./use_kibana");
var _use_is_agent_builder_enabled = require("./use_is_agent_builder_enabled");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentBuilderOptIn = ({
  navigateFromConversationApp = false
} = {}) => {
  var _plugins$start, _application$capabili, _application$capabili2;
  const {
    application,
    notifications,
    settings,
    plugins
  } = (0, _use_kibana.useKibana)().services;
  const onechat = plugins === null || plugins === void 0 ? void 0 : (_plugins$start = plugins.start) === null || _plugins$start === void 0 ? void 0 : _plugins$start.onechat;
  const {
    hasAgentBuilderAccess,
    isAgentChatExperienceEnabled
  } = (0, _use_is_agent_builder_enabled.useIsAgentBuilderEnabled)();
  const hasAdvancedSettingsEditPrivilege = Boolean(application === null || application === void 0 ? void 0 : (_application$capabili = application.capabilities) === null || _application$capabili === void 0 ? void 0 : (_application$capabili2 = _application$capabili.advancedSettings) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.save);
  const showAgentBuilderOptInCta = (0, _react.useMemo)(() => Boolean(onechat === null || onechat === void 0 ? void 0 : onechat.openConversationFlyout) && hasAdvancedSettingsEditPrivilege && hasAgentBuilderAccess && !isAgentChatExperienceEnabled, [onechat, hasAdvancedSettingsEditPrivilege, hasAgentBuilderAccess, isAgentChatExperienceEnabled]);
  const [isAgentBuilderConfirmationModalOpen, setIsAgentBuilderConfirmationModalOpen] = (0, _react.useState)(false);
  const openAgentBuilderConfirmationModal = (0, _react.useCallback)(() => {
    setIsAgentBuilderConfirmationModalOpen(true);
  }, []);
  const closeAgentBuilderConfirmationModal = (0, _react.useCallback)(() => {
    setIsAgentBuilderConfirmationModalOpen(false);
  }, []);
  const confirmAgentBuilderOptIn = (0, _react.useCallback)(async () => {
    setIsAgentBuilderConfirmationModalOpen(false);
    if (!onechat) {
      return;
    }
    try {
      await settings.client.set(_public.PREFERRED_CHAT_EXPERIENCE_SETTING_KEY, _aiAssistantCommon.AIChatExperience.Agent);
      if (navigateFromConversationApp) {
        await application.navigateToApp('observability', {
          path: '/'
        });
      }
      onechat.openConversationFlyout({
        newConversation: true
      });
    } catch (error) {
      var _error$body;
      const toastError = error !== null && error !== void 0 && (_error$body = error.body) !== null && _error$body !== void 0 && _error$body.message ? new Error(error.body.message) : error;
      notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(toastError, {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistant.agentTour.errorTitle', {
          defaultMessage: 'Could not switch to AI Agent experience'
        }),
        toastMessage: error === null || error === void 0 ? void 0 : error.message
      });
    }
  }, [application, navigateFromConversationApp, notifications === null || notifications === void 0 ? void 0 : notifications.toasts, onechat, settings.client]);
  return {
    showAgentBuilderOptInCta,
    isAgentBuilderConfirmationModalOpen,
    openAgentBuilderConfirmationModal,
    closeAgentBuilderConfirmationModal,
    confirmAgentBuilderOptIn
  };
};
exports.useAgentBuilderOptIn = useAgentBuilderOptIn;