"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runAndValidateEsqlQuery = runAndValidateEsqlQuery;
var _esqlAst = require("@kbn/esql-ast");
var _fieldTypes = require("@kbn/field-types");
var _common = require("@kbn/inference-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function runAndValidateEsqlQuery({
  query,
  client,
  signal
}) {
  const queryWithoutLineBreaks = query.replaceAll(/\n/g, '');
  const {
    errors
  } = await (0, _esqlAst.validateQuery)(queryWithoutLineBreaks);
  const asCommands = (0, _common.splitIntoCommands)(queryWithoutLineBreaks);
  const errorMessages = errors === null || errors === void 0 ? void 0 : errors.map(error => {
    if ('location' in error) {
      const commandsUntilEndOfError = (0, _common.splitIntoCommands)(queryWithoutLineBreaks.substring(0, error.location.max));
      const lastCompleteCommand = asCommands[commandsUntilEndOfError.length - 1];
      if (lastCompleteCommand) {
        return `Error in ${lastCompleteCommand.command}\n: ${error.text}`;
      }
    }
    return 'text' in error ? error.text : error.message;
  });
  try {
    var _esqlResponse$columns, _esqlResponse$columns2;
    const res = await client.esql.query({
      query,
      drop_null_columns: true
    }, {
      signal,
      requestTimeout: '10s'
    });
    const esqlResponse = res;
    const columns = (_esqlResponse$columns = (_esqlResponse$columns2 = esqlResponse.columns) === null || _esqlResponse$columns2 === void 0 ? void 0 : _esqlResponse$columns2.map(({
      name,
      type
    }) => ({
      id: name,
      name,
      meta: {
        type: (0, _fieldTypes.esFieldTypeToKibanaFieldType)(type)
      }
    }))) !== null && _esqlResponse$columns !== void 0 ? _esqlResponse$columns : [];
    return {
      columns,
      rows: esqlResponse.values
    };
  } catch (error) {
    return {
      error,
      ...(errorMessages.length ? {
        errorMessages
      } : {})
    };
  }
}