"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createElasticsearchClient = createElasticsearchClient;
var _apmUtils = require("@kbn/apm-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createElasticsearchClient({
  client,
  inspect,
  logger
}) {
  return {
    search(operationName, parameters) {
      if (inspect) {
        logger.info(`Request (${operationName}):\n${JSON.stringify(parameters, null, 2)}`);
      }
      return (0, _apmUtils.withSpan)({
        name: operationName,
        labels: {
          plugin: 'observability_ai_assistant_app'
        }
      }, () => {
        return client.search(parameters);
      }).then(response => {
        if (inspect) {
          logger.info(`Response (${operationName}):\n${JSON.stringify(response, null, 2)}`);
        }
        return response;
      });
    }
  };
}