"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFunctions = registerFunctions;
var _changes = require("./changes");
var _lens = require("./lens");
var _visualize_esql = require("./visualize_esql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function registerFunctions({
  registerRenderFunction,
  pluginsStart
}) {
  (0, _lens.registerLensRenderFunction)({
    pluginsStart,
    registerRenderFunction
  });
  (0, _visualize_esql.registerVisualizeQueryRenderFunction)({
    pluginsStart,
    registerRenderFunction
  });
  (0, _changes.registerChangesRenderFunction)({
    pluginsStart,
    registerRenderFunction
  });
}