"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootCauseAnalysisEntityLogPatternTable = RootCauseAnalysisEntityLogPatternTable;
exports.getChangeBadge = getChangeBadge;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _integer = require("@kbn/observability-utils-common/format/integer");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_theme = require("../../../hooks/use_theme");
var _spark_plot = require("../../charts/spark_plot");
var _highlight_patterns_from_regex = require("./highlight_patterns_from_regex");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/components/rca/rca_entity_log_pattern_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const badgeClassName = (0, _css.css)`
  width: 100%;
  .euiBadge__content {
    justify-content: center;
  }
`;
const PER_PAGE = 5;
function RootCauseAnalysisEntityLogPatternTable({
  entity,
  ownPatterns,
  patternsFromOtherEntities
}) {
  const theme = (0, _use_theme.useTheme)();
  const [showUsualPatterns, setShowUsualPatterns] = (0, _react.useState)(false);
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const columns = (0, _react.useMemo)(() => {
    return [{
      field: 'relevance',
      name: '',
      width: '128px',
      render: (_, {
        relevance,
        metadata
      }) => {
        const color = getRelevanceColor(relevance);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          className: badgeClassName,
          color: color,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 59,
            columnNumber: 13
          }
        }, relevance);
      }
    }, {
      field: 'pattern',
      name: _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.logPatternTable.messageColumnTitle', {
        defaultMessage: 'Message'
      }),
      render: (_, {
        regex,
        sample
      }) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          className: (0, _css.css)`
                font-family: ${theme.font.familyCode};
                color: ${theme.colors.subduedText};
                em {
                  font-style: normal;
                  font-weight: ${theme.font.weight.semiBold};
                  color: ${theme.colors.primaryText};
                }
              `,
          dangerouslySetInnerHTML: {
            __html: (0, _highlight_patterns_from_regex.highlightPatternFromRegex)(regex, sample)
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 13
          }
        });
      }
    }, {
      field: 'count',
      name: _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.logPatternTable.countColumnTitle', {
        defaultMessage: 'Count'
      }),
      width: '96px',
      render: (_, {
        count
      }) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          className: (0, _css.css)`
                white-space: nowrap;
              `,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 13
          }
        }, (0, _integer.formatInteger)(count));
      }
    }, {
      field: 'change',
      name: _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.logPatternTable.changeColumnTitle', {
        defaultMessage: 'Change'
      }),
      width: '128px',
      render: (_, {
        change
      }) => {
        return getChangeBadge(change);
      }
    }, {
      field: 'timeseries',
      width: '128px',
      name: _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.logPatternTable.trendColumnTitle', {
        defaultMessage: 'Trend'
      }),
      render: (_, {
        timeseries,
        change
      }) => {
        return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
          timeseries: timeseries,
          annotations: getAnnotationsFromChangePoint({
            timeseries,
            change,
            theme
          }),
          type: "bar",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 129,
            columnNumber: 13
          }
        });
      }
    }];
  }, [theme]);
  const allPatterns = (0, _react.useMemo)(() => {
    return [...ownPatterns, ...patternsFromOtherEntities];
  }, [ownPatterns, patternsFromOtherEntities]);
  const items = (0, _react.useMemo)(() => {
    return allPatterns.filter(pattern => {
      if (!showUsualPatterns) {
        return pattern.relevance !== 'normal';
      }
      return pattern;
    });
  }, [allPatterns, showUsualPatterns]);
  const visibleItems = (0, _react.useMemo)(() => {
    const start = pageIndex * PER_PAGE;
    return (0, _lodash.orderBy)(items, item => relevanceToInt(item.relevance), 'desc').slice(start, start + PER_PAGE);
  }, [pageIndex, items]);
  const paginationOptions = (0, _react.useMemo)(() => {
    return {
      pageIndex,
      totalItemCount: items.length,
      pageSize: PER_PAGE
    };
  }, [pageIndex, items.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rootCauseAnalysisEntityInvestigation.logPatternsTableTitle', {
    defaultMessage: 'Showing {count} of {total} log patterns',
    values: {
      total: items.length,
      count: visibleItems.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: `show_usual_patterns_${JSON.stringify(entity)}`,
    checked: showUsualPatterns,
    onChange: () => {
      setShowUsualPatterns(prev => !prev);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.logPatternTable.showUsualPatternsCheckbox', {
    defaultMessage: 'Show unremarkable patterns'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableLayout: "auto",
    columns: columns,
    items: visibleItems,
    pagination: paginationOptions,
    onChange: criteria => {
      setPageIndex(criteria.page.index);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }));
}
function getRelevanceColor(relevance) {
  switch (relevance) {
    case 'normal':
      return 'plain';
    case 'critical':
      return 'danger';
    case 'warning':
      return 'warning';
    case 'unusual':
      return 'primary';
  }
}
function getSignificanceColor(significance) {
  switch (significance) {
    case 'high':
      return 'danger';
    case 'medium':
      return 'warning';
    case 'low':
    case null:
      return 'plain';
  }
}
function relevanceToInt(relevance) {
  switch (relevance) {
    case 'normal':
      return 0;
    case 'unusual':
      return 1;
    case 'warning':
      return 2;
    case 'critical':
      return 3;
  }
}
function getAnnotationsFromChangePoint({
  change,
  theme,
  timeseries
}) {
  if (!change.change_point || !change.type) {
    return [];
  }
  const color = getSignificanceColor(change.significance);
  return [{
    color: color === 'plain' ? theme.colors.subduedText : theme.colors[color],
    id: '1',
    icon: '*',
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 14
      }
    }, change.type),
    x: timeseries[change.change_point].x
  }];
}
function getChangeBadge(change) {
  var _change$significance;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: badgeClassName,
    color: getSignificanceColor(change.significance),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 5
    }
  }, (_change$significance = change.significance) !== null && _change$significance !== void 0 ? _change$significance : 'No change');
}