"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexDescription = void 0;
exports.timeRangeSchemaOptional = timeRangeSchemaOptional;
exports.timeRangeSchemaRequired = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startDescription = 'The start time of the query window using Elasticsearch date math (e.g., "now-24h", "now-15m").';
const endDescription = 'The end time of the query window using Elasticsearch date math (e.g., "now").';
const indexDescription = exports.indexDescription = 'Concrete index or index pattern to analyze (for example `logs-payments.api-default`).';
const timeRangeSchemaRequired = exports.timeRangeSchemaRequired = {
  start: _zod.z.string().describe(startDescription),
  end: _zod.z.string().describe(endDescription)
};
function timeRangeSchemaOptional(defaultTimeRange) {
  return {
    start: _zod.z.string().describe(`${startDescription} Defaults to ${defaultTimeRange.start}.`).default(defaultTimeRange.start),
    end: _zod.z.string().describe(`${endDescription} Defaults to ${defaultTimeRange.end}.`).default(defaultTimeRange.end)
  };
}