"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.environmentFilter = environmentFilter;
exports.kqlFilter = kqlFilter;
exports.termFilter = termFilter;
exports.timeRangeFilter = timeRangeFilter;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function timeRangeFilter(timeField, {
  start,
  end
}) {
  if (!start || !end) {
    return [];
  }
  return [{
    range: {
      [timeField]: {
        gte: start,
        lt: end,
        format: 'epoch_millis'
      }
    }
  }];
}
function kqlFilter(kuery) {
  const hasKuery = !(0, _lodash.isEmpty)(kuery === null || kuery === void 0 ? void 0 : kuery.trim());
  if (hasKuery) {
    return [(0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(kuery))];
  }
  return [];
}
function environmentFilter(environment) {
  if (!environment) {
    return [];
  }
  return [{
    term: {
      'service.environment': environment
    }
  }];
}
function termFilter(field, value) {
  if (!value) {
    return [];
  }
  return [{
    term: {
      [field]: value
    }
  }];
}