"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolHandler = getToolHandler;
var _fetch_log_rate_analysis_for_alert = require("@kbn/aiops-log-rate-analysis/queries/fetch_log_rate_analysis_for_alert");
var _time = require("../../utils/time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getToolHandler({
  esClient,
  logger,
  index,
  timeFieldName,
  baseline,
  deviation,
  searchQuery
}) {
  const windowParameters = {
    baselineMin: (0, _time.parseDatemath)(baseline.start),
    baselineMax: (0, _time.parseDatemath)(baseline.end, {
      roundUp: true
    }),
    deviationMin: (0, _time.parseDatemath)(deviation.start),
    deviationMax: (0, _time.parseDatemath)(deviation.end, {
      roundUp: true
    })
  };
  const response = await (0, _fetch_log_rate_analysis_for_alert.runLogRateAnalysis)({
    esClient,
    arguments: {
      index,
      windowParameters,
      timefield: timeFieldName,
      searchQuery: searchQuery !== null && searchQuery !== void 0 ? searchQuery : {
        match_all: {}
      }
    }
  });
  logger.debug(`Log rate analysis tool (index: "${index}") found ${response.significantItems.length} items of type ${response.logRateAnalysisType}.`);
  return {
    analysisType: response.logRateAnalysisType,
    items: response.significantItems
  };
}