"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolHandler = getToolHandler;
var _lodash = require("lodash");
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _common = require("@kbn/observability-shared-plugin/common");
var _get_total_hits = require("../../utils/get_total_hits");
var _dsl_filters = require("../../utils/dsl_filters");
var _tool = require("./tool");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getToolHandler({
  core,
  request,
  start,
  end,
  kqlFilter,
  includeRecovered,
  fields
}) {
  const [, pluginStart] = await core.getStartServices();
  const {
    ruleRegistry
  } = pluginStart;
  const alertsClient = await ruleRegistry.getRacClientWithRequest(request);
  const response = await alertsClient.find({
    ruleTypeIds: _common.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    consumers: [_technical_rule_data_field_names.AlertConsumers.APM, _technical_rule_data_field_names.AlertConsumers.INFRASTRUCTURE, _technical_rule_data_field_names.AlertConsumers.LOGS, _technical_rule_data_field_names.AlertConsumers.UPTIME, _technical_rule_data_field_names.AlertConsumers.SLO, _technical_rule_data_field_names.AlertConsumers.OBSERVABILITY, _technical_rule_data_field_names.AlertConsumers.ALERTS],
    query: {
      bool: {
        filter: [{
          range: {
            'kibana.alert.start': {
              gte: start,
              lte: end
            }
          }
        }, ...(0, _dsl_filters.kqlFilter)(kqlFilter), ...(includeRecovered ? [] : [{
          term: {
            [_technical_rule_data_field_names.ALERT_STATUS]: _technical_rule_data_field_names.ALERT_STATUS_ACTIVE
          }
        }])]
      }
    },
    size: 10
  });
  const total = (0, _get_total_hits.getTotalHits)(response);
  const fieldsToReturn = fields !== null && fields !== void 0 ? fields : _tool.defaultFields;
  const alerts = response.hits.hits.map(hit => {
    var _hit$_source;
    return (0, _lodash.pick)((_hit$_source = hit._source) !== null && _hit$_source !== void 0 ? _hit$_source : {}, fieldsToReturn);
  });
  return {
    alerts,
    total
  };
}