"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerObservabilityAgent = registerObservabilityAgent;
var _dedent = _interopRequireDefault(require("dedent"));
var _register_tools = require("../tools/register_tools");
var _tools = require("../tools");
var _get_agent_builder_resource_availability = require("../utils/get_agent_builder_resource_availability");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function registerObservabilityAgent({
  core,
  plugins,
  logger
}) {
  var _plugins$onechat;
  (_plugins$onechat = plugins.onechat) === null || _plugins$onechat === void 0 ? void 0 : _plugins$onechat.agents.register({
    id: _constants.OBSERVABILITY_AGENT_ID,
    name: 'Observability Agent',
    description: 'Agent specialized in logs, metrics, and traces',
    avatar_icon: 'logoObservability',
    availability: {
      cacheMode: 'space',
      handler: async ({
        request
      }) => {
        return (0, _get_agent_builder_resource_availability.getAgentBuilderResourceAvailability)({
          core,
          request,
          logger
        });
      }
    },
    configuration: {
      instructions: (0, _dedent.default)(`You are an observability specialist agent that helps Site Reliability Engineers (SREs) investigate incidents and understand system health.
        
        ${getInvestigationInstructions()}
        ${getReasoningInstructions()}
        ${getFieldDiscoveryInstructions()}
      `),
      tools: [{
        tool_ids: _register_tools.OBSERVABILITY_AGENT_TOOL_IDS
      }]
    }
  });
  logger.debug('Successfully registered observability agent in agent-builder');
}
function getInvestigationInstructions() {
  return (0, _dedent.default)(`
    ### INVESTIGATION APPROACH
    
    Follow a progressive workflow - start broad, then narrow down:
    1. **Triage**: What's the severity? How many users/services affected?
    2. **Scope**: Which components are affected? What's the blast radius?
    3. **Timeline**: When did it start? What changed before symptoms appeared?
    4. **Correlation**: What error patterns exist? What's the sequence of events?
    5. **Root Cause**: Distinguish the SOURCE (where the problem started) from AFFECTED services (impacted downstream)
    6. **Verification**: Does your hypothesis explain ALL the symptoms? If not, dig deeper.
  `);
}
function getReasoningInstructions() {
  return (0, _dedent.default)(`
    ### REASONING PRINCIPLES
    
    - **Be quantitative**: Quote specific metrics (error rate %, latency ms, throughput rpm). Avoid vague terms like "high" without numbers.
    - **Correlation ≠ causation**: Look for temporal sequence (what happened FIRST) and causal mechanism.
    - **Consider all layers**: Infrastructure (CPU, memory, disk) → Application (latency, throughput, failure rate) → Dependencies (databases, caches, external APIs).
    - **Follow evidence**: Support hypotheses with data. Acknowledge uncertainty when evidence is inconclusive.
  `);
}
function getFieldDiscoveryInstructions() {
  return (0, _dedent.default)(`
    ### FIELD DISCOVERY
    Before using field names in \`groupBy\`, \`kqlFilter\`, or \`aggregation.field\` parameters, call \`${_tools.OBSERVABILITY_GET_INDEX_INFO_TOOL_ID}\` first.
    Clusters use different naming conventions (ECS vs OpenTelemetry) - discovering fields first prevents errors.
  `);
}