"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAlertAIInsight = createAlertAIInsight;
exports.createErrorSampleAIInsight = createErrorSampleAIInsight;
exports.createLogAIInsight = createLogAIInsight;
exports.createLogsAIInsightRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_agent_builder/public/components/insights/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertAiInsightLazy = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./alert_ai_insight'))).then(m => ({
  default: m.AlertAiInsight
})));
const ErrorSampleAiInsightLazy = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./error_sample_ai_insight'))).then(m => ({
  default: m.ErrorSampleAiInsight
})));
const LogAiInsightLazy = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./log_ai_insight'))).then(m => ({
  default: m.LogAiInsight
})));
function createAlertAIInsight(core, plugins) {
  const {
    Provider: KibanaReactContextProvider
  } = (0, _public.createKibanaReactContext)({
    ...core,
    ...plugins
  });
  return props => /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(AlertAiInsightLazy, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  })));
}
function createErrorSampleAIInsight(core, plugins) {
  const {
    Provider: KibanaReactContextProvider
  } = (0, _public.createKibanaReactContext)({
    ...core,
    ...plugins
  });
  return props => /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ErrorSampleAiInsightLazy, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  })));
}
function createLogAIInsight(core, plugins) {
  return props => {
    const {
      Provider: KibanaReactContextProvider
    } = (0, _public.createKibanaReactContext)({
      ...core,
      ...plugins
    });
    return /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(LogAiInsightLazy, (0, _extends2.default)({}, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    })));
  };
}
const createLogsAIInsightRenderer = LogAIInsightRender => ({
  doc
}) => {
  const mappedDoc = (0, _react.useMemo)(() => ({
    fields: Object.entries(doc.flattened).map(([field, value]) => ({
      field,
      value: Array.isArray(value) ? value : [value]
    }))
  }), [doc]);
  return /*#__PURE__*/_react.default.createElement(LogAIInsightRender, {
    key: doc.id,
    doc: mappedDoc,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 12
    }
  });
};
exports.createLogsAIInsightRenderer = createLogsAIInsightRenderer;