"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiInsightErrorBanner = AiInsightErrorBanner;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_agent_builder/public/components/ai_insight/ai_insight_error_banner.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AiInsightErrorBanner({
  error,
  onRetry
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    iconType: "alert",
    title: _i18n.i18n.translate('xpack.observabilityAgentBuilder.aiInsight.errorTitle', {
      defaultMessage: 'Failed to generate AI insight'
    }),
    "data-test-subj": "AiInsightErrorBanner",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.observabilityAgentBuilder.aiInsight.errorMessage', {
    defaultMessage: 'The AI insight could not be generated: {error}',
    values: {
      error
    }
  })), onRetry && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: onRetry,
    "data-test-subj": "AiInsightErrorBannerRetryButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.observabilityAgentBuilder.aiInsight.retryButton', {
    defaultMessage: 'Try again'
  })));
}