"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapTopNavItemToPanelItem = exports.isDisabled = exports.getTopNavItems = exports.getTooltip = exports.getShouldOverflow = exports.getPopoverPanels = exports.getPopoverActionItems = exports.getIsSelectedColor = exports.getDisplayedItemsAllowedAmount = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _top_nav_menu_popover_action_buttons = require("./top_nav_menu_popover_action_buttons");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu_beta/utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Calculate how many items can be displayed based on the presence of action buttons.
 */
const getDisplayedItemsAllowedAmount = config => {
  const actionButtonsAmount = [config.primaryActionItem, config.secondaryActionItem].filter(Boolean).length;
  return _constants.TOP_NAV_MENU_ITEM_LIMIT - actionButtonsAmount;
};

/**
 * Determine if the menu should overflow into a "more" menu.
 */
exports.getDisplayedItemsAllowedAmount = getDisplayedItemsAllowedAmount;
const getShouldOverflow = ({
  config,
  displayedItemsAllowedAmount
}) => {
  if (!config.items) {
    return false;
  }
  return config.items.length > displayedItemsAllowedAmount;
};

/**
 * Split the items into displayed and overflow based on the configuration.
 */
exports.getShouldOverflow = getShouldOverflow;
const getTopNavItems = ({
  config
}) => {
  if (!config.items) {
    return {
      displayedItems: [],
      overflowItems: [],
      shouldOverflow: false
    };
  }
  const displayedItemsAllowedAmount = getDisplayedItemsAllowedAmount(config);
  const shouldOverflow = getShouldOverflow({
    config,
    displayedItemsAllowedAmount
  });
  const sortedItems = [...config.items].sort((a, b) => a.order - b.order);
  if (!shouldOverflow) {
    return {
      displayedItems: sortedItems,
      overflowItems: [],
      shouldOverflow: false
    };
  }
  const overflowItems = sortedItems.slice(displayedItemsAllowedAmount);
  return {
    displayedItems: sortedItems.slice(0, displayedItemsAllowedAmount),
    overflowItems,
    shouldOverflow: overflowItems.length > 0
  };
};
exports.getTopNavItems = getTopNavItems;
const isDisabled = disableButton => Boolean((0, _lodash.isFunction)(disableButton) ? disableButton() : disableButton);
exports.isDisabled = isDisabled;
const getTooltip = ({
  tooltipContent,
  tooltipTitle
}) => {
  const content = (0, _lodash.isFunction)(tooltipContent) ? tooltipContent() : tooltipContent;
  const title = (0, _lodash.isFunction)(tooltipTitle) ? tooltipTitle() : tooltipTitle;
  return {
    title,
    content
  };
};
exports.getTooltip = getTooltip;
const mapTopNavItemToPanelItem = (item, childPanelId) => {
  const {
    content,
    title
  } = getTooltip({
    tooltipContent: item === null || item === void 0 ? void 0 : item.tooltipContent,
    tooltipTitle: item === null || item === void 0 ? void 0 : item.tooltipTitle
  });
  const handleClick = () => {
    var _item$run;
    if (isDisabled(item === null || item === void 0 ? void 0 : item.disableButton)) {
      return;
    }
    (_item$run = item.run) === null || _item$run === void 0 ? void 0 : _item$run.call(item);
  };
  return {
    key: item.id,
    name: (0, _lodash.upperFirst)(item.label),
    icon: item === null || item === void 0 ? void 0 : item.iconType,
    onClick: item !== null && item !== void 0 && item.href || childPanelId !== undefined ? undefined : handleClick,
    href: item === null || item === void 0 ? void 0 : item.href,
    target: item !== null && item !== void 0 && item.href ? item === null || item === void 0 ? void 0 : item.target : undefined,
    disabled: isDisabled(item === null || item === void 0 ? void 0 : item.disableButton),
    'data-test-subj': item === null || item === void 0 ? void 0 : item.testId,
    toolTipContent: content,
    toolTipProps: {
      title
    },
    ...(childPanelId !== undefined && {
      panel: childPanelId
    })
  };
};
exports.mapTopNavItemToPanelItem = mapTopNavItemToPanelItem;
const createSeparatorItem = key => ({
  isSeparator: true,
  key
});

/**
 * Generate action items for the popover menu. This is only used below "m" breakpoint.
 */
const getPopoverActionItems = ({
  primaryActionItem,
  secondaryActionItem
}) => {
  if (!primaryActionItem && !secondaryActionItem) {
    return [];
  }
  const isHidden = item => {
    if (!item) return true;
    const isHiddenInMobile = (0, _lodash.isArray)(item === null || item === void 0 ? void 0 : item.hidden) && (
    // Check if any of the hidden values match mobile breakpoints
    item.hidden.includes('m') || item.hidden.includes('s') || item.hidden.includes('xs'));
    return (item === null || item === void 0 ? void 0 : item.hidden) === 'all' || isHiddenInMobile;
  };
  const bothButtonsAreHidden = isHidden(primaryActionItem) && isHidden(secondaryActionItem);
  if (bothButtonsAreHidden) {
    return [];
  }
  const seperator = createSeparatorItem('action-items-separator');
  return [seperator, {
    key: 'action-items',
    renderItem: () => /*#__PURE__*/_react.default.createElement(_top_nav_menu_popover_action_buttons.TopNavMenuPopoverActionButtons, {
      primaryActionItem: primaryActionItem,
      secondaryActionItem: secondaryActionItem,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 9
      }
    })
  }];
};

/**
 * Recursively generate EUI context menu panels from the provided menu items.
 */
exports.getPopoverActionItems = getPopoverActionItems;
const getPopoverPanels = ({
  items,
  primaryActionItem,
  secondaryActionItem,
  startPanelId = 0
}) => {
  const panels = [];
  const hasActionItems = Boolean(primaryActionItem || secondaryActionItem);
  let currentPanelId = startPanelId;
  const processItems = (itemsToProcess, panelId, parentTitle) => {
    const panelItems = [];
    itemsToProcess.forEach(item => {
      if (item.seperator === 'above') {
        panelItems.push(createSeparatorItem(`separator-${item.id}`));
      }
      if (item.items && item.items.length > 0) {
        currentPanelId++;
        const childPanelId = currentPanelId;
        processItems(item.items, childPanelId, item.label);
        panelItems.push(mapTopNavItemToPanelItem(item, childPanelId));
      } else {
        panelItems.push(mapTopNavItemToPanelItem(item));
      }
      if (item.seperator === 'below') {
        panelItems.push(createSeparatorItem(`separator-${item.id}`));
      }
    });
    panels.push({
      id: panelId,
      ...(parentTitle && {
        title: (0, _lodash.upperFirst)(parentTitle)
      }),
      items: panelItems
    });
  };
  processItems(items, startPanelId);

  /**
   * Action items are only added to the main panel and only in lower breakpoints (below "m").
   * They should not be available to be added via config.
   */
  if (hasActionItems) {
    const mainPanel = panels.find(panel => panel.id === startPanelId);
    if (!mainPanel) return panels;
    const actionItems = getPopoverActionItems({
      primaryActionItem,
      secondaryActionItem
    });
    mainPanel.items = [...mainPanel.items, ...actionItems];
    return panels;
  }
  return panels;
};

/**
 * Get the background color for a button associated when popover is open.
 */
exports.getPopoverPanels = getPopoverPanels;
const getIsSelectedColor = ({
  color,
  euiTheme,
  isFilled
}) => {
  /**
   * Construct the color key based on whether the button is filled or empty e.g. backgroundFilledPrimaryHover.
   */
  const colorKey = `background${isFilled ? 'Filled' : 'Empty'}${(0, _lodash.upperFirst)(color)}Hover`;
  return euiTheme.components.buttons[colorKey] || euiTheme.colors.backgroundBaseInteractiveHover;
};
exports.getIsSelectedColor = getIsSelectedColor;