"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuOverflowButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _utils = require("./utils");
var _top_nav_menu_popover = require("./top_nav_menu_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu_beta/top_nav_menu_overflow_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const TopNavMenuOverflowButton = ({
  items,
  isPopoverOpen,
  primaryActionItem,
  secondaryActionItem,
  onPopoverToggle,
  onPopoverClose
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (items.length === 0) {
    return null;
  }
  const handleClick = () => {
    onPopoverToggle();
  };
  const buttonCss = (0, _react2.css)`
    background-color: ${isPopoverOpen ? (0, _utils.getIsSelectedColor)({
    color: 'text',
    euiTheme,
    isFilled: false
  }) : undefined};
  `;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "boxesHorizontal" // TODO: Change to "ellipsis" when it's available in EUI.
    ,
    size: "xs",
    "aria-label": _i18n.i18n.translate('navigation.topNavMenu.showMoreButtonLabel', {
      defaultMessage: 'More'
    }),
    color: "text",
    "aria-haspopup": "menu",
    onClick: handleClick,
    isSelected: isPopoverOpen,
    css: buttonCss,
    "data-test-subj": "top-nav-menu-overflow-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_top_nav_menu_popover.TopNavMenuPopover, {
    items: items,
    anchorElement: button,
    tooltipContent: _i18n.i18n.translate('navigation.topNavMenu.showMoreButtonTooltip', {
      defaultMessage: 'More'
    }),
    isOpen: isPopoverOpen,
    popoverWidth: 200,
    primaryActionItem: primaryActionItem,
    secondaryActionItem: secondaryActionItem,
    onClose: onPopoverClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  });
};
exports.TopNavMenuOverflowButton = TopNavMenuOverflowButton;