"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuBeta = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("./utils");
var _top_nav_menu_action_button = require("./top_nav_menu_action_button");
var _top_nav_menu_item = require("./top_nav_menu_item");
var _top_nav_menu_overflow_button = require("./top_nav_menu_overflow_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu_beta/top_nav_menu_beta.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const hasNoItems = config => {
  var _config$items;
  return !((_config$items = config.items) !== null && _config$items !== void 0 && _config$items.length) && !(config !== null && config !== void 0 && config.primaryActionItem) && !(config !== null && config !== void 0 && config.secondaryActionItem);
};
const TopNavMenuBeta = ({
  config,
  visible = true
}) => {
  const [openPopoverId, setOpenPopoverId] = (0, _react.useState)(null);
  const isBetweenMandXlBreakpoint = (0, _eui.useIsWithinBreakpoints)(['m', 'l']);
  const isAboveXlBreakpoint = (0, _eui.useIsWithinBreakpoints)(['xl']);
  if (!config || hasNoItems(config) || !visible) {
    return null;
  }
  const primaryActionItem = config === null || config === void 0 ? void 0 : config.primaryActionItem;
  const secondaryActionItem = config === null || config === void 0 ? void 0 : config.secondaryActionItem;
  const showMoreButtonId = 'show-more';
  const headerLinksProps = {
    'data-test-subj': 'top-nav',
    gutterSize: 'xs',
    popoverBreakpoints: 'none',
    className: 'kbnTopNavMenu__wrapper'
  };
  const {
    displayedItems,
    overflowItems,
    shouldOverflow
  } = (0, _utils.getTopNavItems)({
    config
  });
  const handlePopoverToggle = id => {
    setOpenPopoverId(openPopoverId === id ? null : id);
  };
  const handleOnPopoverClose = () => {
    setOpenPopoverId(null);
  };
  const primaryActionComponent = primaryActionItem ? /*#__PURE__*/_react.default.createElement(_top_nav_menu_action_button.TopNavMenuActionButton, (0, _extends2.default)({}, primaryActionItem, {
    isPopoverOpen: openPopoverId === primaryActionItem.id,
    onPopoverToggle: () => {
      handlePopoverToggle(primaryActionItem.id);
    },
    onPopoverClose: handleOnPopoverClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  })) : undefined;
  const secondaryActionComponent = secondaryActionItem ? /*#__PURE__*/_react.default.createElement(_top_nav_menu_action_button.TopNavMenuActionButton, (0, _extends2.default)({}, secondaryActionItem, {
    isPopoverOpen: openPopoverId === secondaryActionItem.id,
    onPopoverToggle: () => {
      handlePopoverToggle(secondaryActionItem.id);
    },
    onPopoverClose: handleOnPopoverClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  })) : undefined;
  if (isBetweenMandXlBreakpoint) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, (0, _extends2.default)({}, headerLinksProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_top_nav_menu_overflow_button.TopNavMenuOverflowButton, {
      items: [...displayedItems, ...overflowItems],
      isPopoverOpen: openPopoverId === showMoreButtonId,
      onPopoverToggle: () => handlePopoverToggle(showMoreButtonId),
      onPopoverClose: handleOnPopoverClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }), secondaryActionComponent, primaryActionComponent);
  }
  if (isAboveXlBreakpoint) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, (0, _extends2.default)({}, headerLinksProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 7
      }
    }), (displayedItems === null || displayedItems === void 0 ? void 0 : displayedItems.length) > 0 && displayedItems.map(menuItem => /*#__PURE__*/_react.default.createElement(_top_nav_menu_item.TopNavMenuItem, (0, _extends2.default)({
      key: menuItem.id
    }, menuItem, {
      isPopoverOpen: openPopoverId === menuItem.id,
      onPopoverToggle: () => handlePopoverToggle(menuItem.id),
      onPopoverClose: handleOnPopoverClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    }))), shouldOverflow && /*#__PURE__*/_react.default.createElement(_top_nav_menu_overflow_button.TopNavMenuOverflowButton, {
      items: overflowItems,
      isPopoverOpen: openPopoverId === showMoreButtonId,
      onPopoverToggle: () => handlePopoverToggle(showMoreButtonId),
      onPopoverClose: handleOnPopoverClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }), secondaryActionComponent, primaryActionComponent);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, (0, _extends2.default)({}, headerLinksProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_top_nav_menu_overflow_button.TopNavMenuOverflowButton, {
    items: [...displayedItems, ...overflowItems],
    isPopoverOpen: openPopoverId === showMoreButtonId,
    secondaryActionItem: secondaryActionItem,
    primaryActionItem: primaryActionItem,
    onPopoverToggle: () => handlePopoverToggle(showMoreButtonId),
    onPopoverClose: handleOnPopoverClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }));
};
exports.TopNavMenuBeta = TopNavMenuBeta;