"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.numberOfRulesLabel = exports.numberOfAlertsLabel = exports.AlertsBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _setup_mode = require("../lib/setup_mode");
var _setup_mode_context = require("../components/setup_mode/setup_mode_context");
var _get_alert_panels_by_category = require("./lib/get_alert_panels_by_category");
var _get_alert_panels_by_node = require("./lib/get_alert_panels_by_node");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const numberOfAlertsLabel = count => `${count} alert${count > 1 ? 's' : ''}`;
exports.numberOfAlertsLabel = numberOfAlertsLabel;
const numberOfRulesLabel = count => `${count} rule${count > 1 ? 's' : ''}`;
exports.numberOfRulesLabel = numberOfRulesLabel;
const MAX_TO_SHOW_BY_CATEGORY = 8;
const PANEL_TITLE_ALERTS = _i18n.i18n.translate('xpack.monitoring.alerts.badge.panelTitle', {
  defaultMessage: 'Alerts'
});
const PANEL_TITLE_RULES = _i18n.i18n.translate('xpack.monitoring.rules.badge.panelTitle', {
  defaultMessage: 'Rules'
});
const GROUP_BY_NODE = _i18n.i18n.translate('xpack.monitoring.alerts.badge.groupByNode', {
  defaultMessage: 'Group by node'
});
const GROUP_BY_TYPE = _i18n.i18n.translate('xpack.monitoring.alerts.badge.groupByType', {
  defaultMessage: 'Group by alert type'
});
const AlertsBadge = props => {
  // We do not always have the alerts that each consumer wants due to licensing
  const {
    stateFilter = () => true
  } = props;
  const alertsList = Object.values(props.alerts).flat();
  const alerts = alertsList.filter(alertItem => Boolean(alertItem === null || alertItem === void 0 ? void 0 : alertItem.sanitizedRule));
  const [showPopover, setShowPopover] = _react.default.useState(null);
  const inSetupMode = (0, _setup_mode.isInSetupMode)(_react.default.useContext(_setup_mode_context.SetupModeContext));
  const alertCount = inSetupMode ? alerts.length : alerts.reduce((sum, {
    states
  }) => sum + states.filter(({
    state
  }) => stateFilter(state)).length, 0);
  const [showByNode, setShowByNode] = _react.default.useState(!inSetupMode && alertCount > MAX_TO_SHOW_BY_CATEGORY);
  const PANEL_TITLE = inSetupMode ? PANEL_TITLE_RULES : PANEL_TITLE_ALERTS;
  _react.default.useEffect(() => {
    if (inSetupMode && showByNode) {
      setShowByNode(false);
    }
  }, [inSetupMode, showByNode]);
  if (alertCount === 0) {
    return null;
  }
  const groupByType = GROUP_BY_NODE;
  const panels = showByNode ? (0, _get_alert_panels_by_node.getAlertPanelsByNode)(PANEL_TITLE, alerts, stateFilter) : (0, _get_alert_panels_by_category.getAlertPanelsByCategory)(PANEL_TITLE, !!inSetupMode, alerts, stateFilter);
  if (panels.length && !inSetupMode && panels[0].items) {
    panels[0].items.push(...[{
      isSeparator: true
    }, {
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        checked: false,
        onChange: () => setShowByNode(!showByNode),
        label: showByNode ? GROUP_BY_TYPE : groupByType,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 13
        }
      })
    }]);
  }
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "bell",
    color: inSetupMode ? 'default' : 'danger',
    "data-test-subj": "alertsBadge",
    onClickAriaLabel: inSetupMode ? numberOfRulesLabel(alertCount) : numberOfAlertsLabel(alertCount),
    onClick: () => setShowPopover(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, inSetupMode ? numberOfRulesLabel(alertCount) : numberOfAlertsLabel(alertCount));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "monitoringAlertMenu",
    button: button,
    isOpen: showPopover === true,
    closePopover: () => setShowPopover(null),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    key: `${showByNode ? 'byNode' : 'byType'}_${panels.length}`,
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }));
};
exports.AlertsBadge = AlertsBadge;