/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.ml_bundle_jsonpfunction=self.ml_bundle_jsonpfunction||[]).push([[3223],{14595:(e,t,s)=>{function a(e,t,s){return(s?e.filter((e=>{const t=e.entityName,a=e.entityValue;return s.some((e=>e.fieldName===t&&e.fieldValue===a))})):e).reduce(((e,s)=>{if(!e)return s;const a=Math.abs(t-e.source.timestamp);return Math.abs(t-s.source.timestamp)<a?s:e}),void 0)}s.d(t,{O:()=>a})},53696:(e,t,s)=>{s.d(t,{K:()=>B,L:()=>ForecastingModal});var a=s(68915),o=s(30770),i=s(84286),r=s.n(i),n=s(81319),l=s(75008),c=s(20409),u=s(43627),d=s(64189),h=s(99280);const m="error",p="warning";var f=s(62106),g=s(3185),x=s(70452),v=s.n(x),b=s(96791);function y({message:e,status:t,...s}){return(0,b.jsx)(n.EuiCallOut,(0,g.default)({size:"s"},function(e,t){switch(t){case m:return{title:e,iconType:"cross",color:"danger"};case p:return{title:e,iconType:"warning",color:"warning"};case"success":return{title:e,iconType:"check",color:"success"};case"info":return{title:e,iconType:"info",color:"primary"}}}(e,t),s))}var S=s(67140),M=s(23120),F=s(42100),E=s(75879);function w(e){return[{field:"forecast_create_timestamp",name:l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastsList.createdColumnName",{defaultMessage:"Created"}),dataType:"date",render:e=>(0,F.v_)(e),sortable:!0},{field:"forecast_start_timestamp",name:l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastsList.fromColumnName",{defaultMessage:"From"}),dataType:"date",render:e=>(0,F.v_)(e),sortable:!0},{field:"forecast_end_timestamp",name:l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastsList.toColumnName",{defaultMessage:"To"}),dataType:"date",render:e=>(0,F.v_)(e),sortable:!0},{name:l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastsList.viewColumnName",{defaultMessage:"View"}),width:"60px",render:t=>{const s=l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastsList.viewForecastAriaLabel",{defaultMessage:"View forecast created at {createdDate}",values:{createdDate:(0,F.v_)(t.forecast_create_timestamp)}});return(0,b.jsx)(n.EuiButtonIcon,{onClick:()=>e(t.forecast_id),iconType:"singleMetricViewer","aria-label":s})}}]}function k({forecasts:e,viewForecast:t,selectedForecastId:s}){const{euiTheme:a}=(0,n.useEuiTheme)();return(0,b.jsx)(n.EuiText,null,(0,b.jsx)("h3",{"aria-describedby":"ml_aria_description_forecasting_modal_view_list"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastsList.previousForecastsTitle",defaultMessage:"Previous forecasts"})," ",(0,b.jsx)(n.EuiIconTip,{size:"s",type:"question",content:(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastsList.listsOfFiveRecentlyRunForecastsTooltip",defaultMessage:"Lists a maximum of five of the most recently run forecasts."})})),(0,b.jsx)(n.EuiInMemoryTable,{items:e,columns:w(t),pagination:!1,"data-test-subj":"mlModalForecastTable",rowProps:e=>({"data-test-subj":`mlForecastsListRow row-${e.rowId}`,...e.forecast_id===s?{style:{backgroundColor:`${a.colors.backgroundBasePrimary}`}}:{}})}))}k.propType={forecasts:v().array,viewForecast:v().func.isRequired,selectedForecastId:v().string};const j=-1,A=-10;function C({state:e}){return 0===e?(0,b.jsx)(n.EuiLoadingSpinner,{size:"m"}):1===e?(0,b.jsx)(n.EuiIcon,{type:"check",size:"m",color:"primary"}):e===A?(0,b.jsx)(n.EuiIcon,{type:"cross",size:"m",color:"danger"}):void 0}function _({forecastProgress:e,jobOpeningState:t,jobClosingState:s}){return(0,b.jsx)("div",null,t!==j&&(0,b.jsx)(r().Fragment,null,(0,b.jsx)(n.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiText,{size:"m"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.openingJobTitle",defaultMessage:"Opening job…"}))),(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(C,{state:t}))),(0,b.jsx)(n.EuiSpacer,{size:"s"})),e!==j&&(0,b.jsx)(r().Fragment,null,(0,b.jsx)(n.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiText,{size:"m"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.runningForecastTitle",defaultMessage:"Running forecast…"}))),e>=0&&(0,b.jsx)(n.EuiFlexItem,null,(0,b.jsx)(n.EuiToolTip,{position:"top",content:e+"%"},(0,b.jsx)(n.EuiProgress,{size:"l",value:e,max:100}))),e===A&&(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(C,{state:A}))),(0,b.jsx)(n.EuiSpacer,{size:"s"})),s!==j&&(0,b.jsx)(r().Fragment,null,(0,b.jsx)(n.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiText,{size:"m"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.closingJobTitle",defaultMessage:"Closing job…"}))),(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(C,{state:s})))))}_.propType={forecastProgress:v().number,jobOpeningState:v().number,jobClosingState:v().number};var T=s(26192);function I({job:e,mlNodesAvailable:t,newForecastDuration:s,isNewForecastDurationValid:a,newForecastDurationErrors:o,neverExpires:i,onNeverExpiresChange:r,onNewForecastDurationChange:c,runForecast:u,isForecastRequested:d,forecastProgress:m,jobOpeningState:p,jobClosingState:f,jobState:g}){const x=function(e,t,s,a){return!1===s?{isDisabled:!0,isDisabledToolTipText:l.i18n.translate("xpack.ml.timeSeriesExplorer.runControls.noMLNodesAvailableTooltip",{defaultMessage:"There are no ML nodes available."})}:!1===(0,T.checkPermission)("canForecastJob")?{isDisabled:!0,isDisabledToolTipText:(0,T.createPermissionFailureMessage)("canForecastJob")}:a!==h.EW.OPENED&&a!==h.EW.CLOSED?{isDisabled:!0,isDisabledToolTipText:l.i18n.translate("xpack.ml.timeSeriesExplorer.runControls.forecastsCanNotBeRunOnJobsTooltip",{defaultMessage:"Forecasts cannot be run on {jobState} jobs",values:{jobState:a}})}:{isDisabled:t}}(0,d,t,g),v=(0,b.jsx)(n.EuiFieldText,{name:"forecastDuration",value:s,disabled:x.isDisabled,isInvalid:!a,onChange:c,fullWidth:!0}),y=(0,b.jsx)(n.EuiButton,{onClick:u,isDisabled:x.isDisabled||!a,"data-test-subj":"mlModalForecastButtonRun"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.runControls.runButtonLabel",defaultMessage:"Run"}));return(0,b.jsx)("div",null,(0,b.jsx)(n.EuiText,null,(0,b.jsx)("h3",null,(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.runControls.runNewForecastTitle",defaultMessage:"Run a new forecast"}))),(0,b.jsx)(n.EuiSpacer,{size:"s"}),(0,b.jsx)(n.EuiForm,null,(0,b.jsx)(n.EuiFlexGroup,{direction:"column"},(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiFormRow,{label:(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.runControls.durationLabel",defaultMessage:"Duration"}),fullWidth:!0,isInvalid:!a,error:o,helpText:(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.runControls.forecastMaximumLengthHelpText",defaultMessage:"Length of forecast, up to a maximum of {maximumForecastDurationDays} days. Use s for seconds, m for minutes, h for hours, d for days, w for weeks.",values:{maximumForecastDurationDays:B}})},void 0===x.isDisabledToolTipText?v:(0,b.jsx)(n.EuiToolTip,{position:"right",content:x.isDisabledToolTipText},v))),(0,b.jsx)(n.EuiFlexItem,null,(0,b.jsx)(n.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiFormRow,{helpText:l.i18n.translate("xpack.ml.timeSeriesExplorer.runControls.neverExpireHelpText",{defaultMessage:"If disabled, forecasts will be retained for 14 days."})},(0,b.jsx)(n.EuiSwitch,{"data-test-subj":"mlModalForecastNeverExpireSwitch",disabled:x.isDisabled,label:l.i18n.translate("xpack.ml.timeSeriesExplorer.runControls.neverExpireLabel",{defaultMessage:"Never expire"}),checked:i,onChange:r}))),(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiFormRow,{hasEmptyLabelSpace:!0},void 0===x.isDisabledToolTipText?y:(0,b.jsx)(n.EuiToolTip,{position:"left",content:x.isDisabledToolTipText},y))))))),(0,b.jsx)(n.EuiSpacer,{size:"s"}),!0===d&&(0,b.jsx)(_,{forecastProgress:m,jobOpeningState:p,jobClosingState:f}))}I.propType={job:v().object,newForecastDuration:v().string,isNewForecastDurationValid:v().bool,newForecastDurationErrors:v().array,neverExpires:v().bool.isRequired,onNewForecastDurationChange:v().func.isRequired,onNeverExpiresChange:v().func.isRequired,runForecast:v().func.isRequired,isForecastRequested:v().bool,forecastProgress:v().number,jobOpeningState:v().number,jobClosingState:v().number};var D=s(43721);function N(e){const t=(0,n.useGeneratedHtmlId)(),[s,a]=(0,i.useState)(!1),{services:{mlServices:{mlApi:o}}}=(0,S.hk)();return(0,i.useEffect)((function(){(0,M.JS)(o).then((({count:e,lazyNodeCount:t})=>{a(0!==e||0!==t)})).catch(D.error)}),[o]),(0,b.jsx)(n.EuiModal,{"aria-labelledby":t,onClose:e.close,maxWidth:860,"data-test-subj":"mlModalForecast"},(0,b.jsx)(n.EuiModalHeader,null,(0,b.jsx)(n.EuiModalHeaderTitle,{id:t},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.forecastingTitle",defaultMessage:"Forecasting"}))),(0,b.jsx)(n.EuiModalBody,null,e.messages.map(((e,t)=>(0,b.jsx)(r().Fragment,{key:t},(0,b.jsx)(y,e),(0,b.jsx)(n.EuiSpacer,{size:"m"})))),e.forecasts.length>0&&(0,b.jsx)(r().Fragment,null,(0,b.jsx)(k,{forecasts:e.forecasts,viewForecast:e.viewForecast,selectedForecastId:e.selectedForecastId}),(0,b.jsx)(n.EuiSpacer,null)),(0,b.jsx)(I,(0,g.default)({},e,{mlNodesAvailable:s,jobState:e.jobState}))),(0,b.jsx)(n.EuiModalFooter,null,(0,b.jsx)(n.EuiButtonEmpty,{onClick:e.close,size:"s","data-test-subj":"mlModalForecastButtonClose"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.closeButtonLabel",defaultMessage:"Close"}))))}N.propType={job:v().object,forecasts:v().array,close:v().func.isRequired,viewForecast:v().func.isRequired,runForecast:v().func.isRequired,newForecastDuration:v().string,isNewForecastDurationValid:v().bool,newForecastDurationErrors:v().array,onNewForecastDurationChange:v().func.isRequired,isForecastRequested:v().bool,forecastProgress:v().number,jobOpeningState:v().number,jobClosingState:v().number,messages:v().array,selectedForecastId:v().string};var O=s(84315);const P=({isDisabled:e,onClick:t,mode:s="full"})=>{const a="full"===s?n.EuiButton:n.EuiButtonEmpty;return(0,b.jsx)(a,{color:"full"===s?"text":"primary",onClick:t,isDisabled:e,"data-test-subj":"mlSingleMetricViewerButtonForecast"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.forecastButtonLabel",defaultMessage:"Forecast"}))};var R=s(43721);const B=3650,L={term:{forecast_status:h.QX.FINISHED}},z="6.1.0",V=864e5*B,W=12e4;function X(){return{isModalVisible:!1,previousForecasts:[],isForecastRequested:!1,forecastProgress:j,jobOpeningState:j,jobClosingState:j,newForecastDuration:"1d",isNewForecastDurationValid:!0,newForecastDurationErrors:[],neverExpires:!1,messages:[]}}class ForecastingModal extends i.Component{constructor(e){super(e),(0,a.default)(this,"addMessage",((e,t,s=!1)=>{const a={message:e,status:t};this.setState((e=>({messages:s?[a]:[...e.messages,a]})))})),(0,a.default)(this,"viewForecast",(e=>{if(this.props.setForecastId(e),void 0!==this.props.onForecastComplete&&this.state.previousForecasts.length>0){const t=this.state.previousForecasts.find((t=>e===t.forecast_id));this.props.onForecastComplete(t.forecast_end_timestamp)}this.closeModal()})),(0,a.default)(this,"onNeverExpiresChange",(e=>{this.setState({neverExpires:e.target.checked})})),(0,a.default)(this,"onNewForecastDurationChange",(e=>{const t=[];let s=!0;const a=(0,d.P)(e.target.value);null===a?(s=!1,t.push(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.invalidDurationFormatErrorMessage",{defaultMessage:"Invalid duration format"}))):a.asMilliseconds()>V?(s=!1,t.push(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.forecastDurationMustNotBeGreaterThanMaximumErrorMessage",{defaultMessage:"Forecast duration must not be greater than {maximumForecastDurationDays} days",values:{maximumForecastDurationDays:B}}))):0===a.asMilliseconds()&&(s=!1,t.push(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.forecastDurationMustNotBeZeroErrorMessage",{defaultMessage:"Forecast duration must not be zero"}))),this.setState({newForecastDuration:e.target.value,isNewForecastDurationValid:s,newForecastDurationErrors:t})})),(0,a.default)(this,"checkJobStateAndRunForecast",(()=>{this.setState({isForecastRequested:!0,messages:[]}),this.props.jobState===h.EW.CLOSED||this.props.job.state===h.EW.CLOSED?this.openJobAndRunForecast():this.runForecast(!1)})),(0,a.default)(this,"openJobAndRunForecast",(()=>{this.setState({jobOpeningState:0}),this.context.services.mlServices.mlApi.openJob({jobId:this.props.job.job_id}).then((()=>{this.setState({jobOpeningState:1}),this.runForecast(!0)})).catch((e=>{R.log("Time series forecast modal - could not open job:",e),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorWithOpeningJobBeforeRunningForecastErrorMessage",{defaultMessage:"Error opening job before running forecast"}),m),this.setState({jobOpeningState:A})}))})),(0,a.default)(this,"runForecastErrorHandler",((e,t)=>{this.setState({forecastProgress:A}),R.log("Time series forecast modal - error running forecast:",e);const s=e?(0,u.P)(e):void 0;s&&s.length>0?this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorRunningForecastMessage",{defaultMessage:"An error has occurred running the forecast: {errorMessage}",values:{errorMessage:s}}),m,!0):this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.unexpectedResponseFromRunningForecastErrorMessage",{defaultMessage:"Unexpected response from running forecast. The request may have failed."}),m,!0),!0===t&&(this.setState({jobClosingState:0}),this.context.services.mlServices.mlApi.closeJob({jobId:this.props.job.job_id}).then((()=>{this.setState({jobClosingState:1})})).catch((e=>{R.log("Time series forecast modal - could not close job:",e),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorWithClosingJobErrorMessage",{defaultMessage:"Error closing job"}),m),this.setState({jobClosingState:A})})))})),(0,a.default)(this,"runForecast",(e=>{this.setState({forecastProgress:0});const t=(0,d.P)(this.state.newForecastDuration).asSeconds();this.mlForecastService.runForecast(this.props.job.job_id,`${t}s`,this.state.neverExpires).then((t=>{void 0!==t.forecast_id?this.waitForForecastResults(t.forecast_id,e):this.runForecastErrorHandler(t,e)})).catch((t=>this.runForecastErrorHandler(t,e)))})),(0,a.default)(this,"waitForForecastResults",((e,t)=>{let s=0,a=0;this.forecastChecker=setInterval((()=>{this.mlForecastService.getForecastRequestStats(this.props.job,e).then((i=>{const r=(0,o.get)(i,["stats","forecast_progress"],s),n=(0,o.get)(i,["stats","forecast_status"]);r>s&&this.setState({forecastProgress:Math.round(100*r)});let c=(0,o.get)(i,["stats","forecast_messages"],[]);c=c.map((e=>({message:e,status:p}))),this.setState({messages:c}),n===h.QX.FINISHED?(clearInterval(this.forecastChecker),void 0!==this.props.onForecastComplete&&this.props.onForecastComplete(i.stats.forecast_end_timestamp),!0===t?(this.setState({jobClosingState:0}),this.context.services.mlServices.mlApi.closeJob({jobId:this.props.job.job_id}).then((()=>{this.setState({jobClosingState:1}),this.props.setForecastId(e),this.closeAfterRunningForecast()})).catch((t=>{R.log("Time series forecast modal - could not close job:",t),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorWithClosingJobAfterRunningForecastErrorMessage",{defaultMessage:"Error closing job after running forecast"}),m),this.setState({jobClosingState:A}),this.props.setForecastId(e)}))):(this.props.setForecastId(e),this.closeAfterRunningForecast())):r===s?(a+=250,a>W&&(R.log("Forecast request has not progressed for 120000ms. Cancelling check."),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.noProgressReportedForNewForecastErrorMessage",{defaultMessage:"No progress reported for the new forecast for {WarnNoProgressMs}ms.An error may have occurred whilst running the forecast.",values:{WarnNoProgressMs:W}}),m),this.props.setForecastId(e),this.setState({forecastProgress:A}),clearInterval(this.forecastChecker))):(r>s&&(s=r),a=0)})).catch((e=>{R.log("Time series forecast modal - error loading stats of forecast from elasticsearch:",e),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorWithLoadingStatsOfRunningForecastErrorMessage",{defaultMessage:"Error loading stats of running forecast."}),m),this.setState({forecastProgress:A}),clearInterval(this.forecastChecker)}))}),250)})),(0,a.default)(this,"openModal",(()=>{const{job:e,entities:t,earliestRecordTimestamp:s,latestRecordTimestamp:a}=this.props;if("object"==typeof e){const{timefilter:o}=this.context.services.data.query.timefilter,i=o.getActiveBounds();this.mlForecastService.getForecastsSummary(e,L,i.min.valueOf(),5).then((e=>{this.setState({previousForecasts:e.forecasts})})).catch((e=>{R.log("Time series forecast modal - error obtaining forecasts summary:",e),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorWithObtainingListOfPreviousForecastsErrorMessage",{defaultMessage:"Error obtaining list of previous forecasts"}),m)}));const r=t.map((e=>e.fieldName));r.length>0&&this.context.services.mlServices.mlApi.getCardinalityOfFields({index:e.datafeed_config.indices,fieldNames:r,query:e.datafeed_config.query,timeFieldName:e.data_description.time_field,earliestMs:s,latestMs:a}).then((e=>{let t=1;Object.values(e).forEach((e=>{t*=e})),t>100&&this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.dataContainsMorePartitionsMessage",{defaultMessage:"Note that this data contains more than {warnNumPartitions} partitions so running a forecast may take a long time and consume a high amount of resource",values:{warnNumPartitions:100}}),p)})).catch((e=>{R.log("Time series forecast modal - error obtaining cardinality of fields:",e)})),this.setState({isModalVisible:!0})}})),(0,a.default)(this,"closeAfterRunningForecast",(()=>{0===this.state.messages.length&&setTimeout((()=>{this.closeModal()}),1e3)})),(0,a.default)(this,"closeModal",(()=>{null!==this.forecastChecker&&clearInterval(this.forecastChecker),this.setState(X())})),this.state=X(),this.forecastChecker=null,this.mlForecastService}componentDidMount(){this.mlForecastService=(0,O.P)(this.context.services.mlServices.mlApi)}render(){let e=!1,t=null;const{job:s}=this.props;void 0!==s&&(void 0!==s.analysis_config.detectors[this.props.detectorIndex].over_field_name?(e=!0,t=l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.forecastingNotAvailableForPopulationDetectorsMessage",{defaultMessage:"Forecasting is not available for population detectors with an over field"})):!1===(0,f.KZ)(s,z)&&(e=!0,t=l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.forecastingOnlyAvailableForJobsCreatedInSpecifiedVersionMessage",{defaultMessage:"Forecasting is only available for jobs created in version {minVersion} or later",values:{minVersion:z}})));const a=(0,b.jsx)(P,{onClick:this.openModal,isDisabled:e,mode:this.props.buttonMode});return(0,b.jsx)("div",null,e?(0,b.jsx)(n.EuiToolTip,{position:"left",content:t},a):a,this.state.isModalVisible&&(0,b.jsx)(N,{jobState:this.props.jobState,job:this.props.job,forecasts:this.state.previousForecasts,close:this.closeModal,viewForecast:this.viewForecast,runForecast:this.checkJobStateAndRunForecast,newForecastDuration:this.state.newForecastDuration,onNewForecastDurationChange:this.onNewForecastDurationChange,onNeverExpiresChange:this.onNeverExpiresChange,neverExpires:this.state.neverExpires,isNewForecastDurationValid:this.state.isNewForecastDurationValid,newForecastDurationErrors:this.state.newForecastDurationErrors,isForecastRequested:this.state.isForecastRequested,forecastProgress:this.state.forecastProgress,jobOpeningState:this.state.jobOpeningState,jobClosingState:this.state.jobClosingState,messages:this.state.messages,selectedForecastId:this.props.selectedForecastId}))}}(0,a.default)(ForecastingModal,"contextType",c.context)},80833:(e,t,s)=>{s.d(t,{Z:()=>se});var a=s(3185),o=s(84286),i=s.n(o),r=s(75008),n=s(43627),l=s(14651),c=s(68915),u=s(77880),d=s(30770),h=s(47935),m=s.n(h),p=s(51783),f=s.n(p),g=s(81319),x=s(73601),v=s(37110),b=s(60203),y=s(74923),S=s(42100),M=s(20409),F=s(14595),E=s(56478),w=s(17404),k=s(28419),j=s(24418);function A(e,t,s,a){this.contextGroup=e,this.data=t,this.drawBounds=s,this.swimlaneHeight=a,this.mask=this.contextGroup.append("g").attr("class","mask"),this.leftGroup=this.mask.append("g").attr("class","left-mask"),this.rightGroup=this.mask.append("g").attr("class","right-mask"),this.leftPolygon=this.leftGroup.append("polygon"),this.rightPolygon=this.rightGroup.append("polygon"),!0===this.drawBounds&&(this.leftGroup.append("path").attr("class","left area bounds"),this.rightGroup.append("path").attr("class","right area bounds")),this.leftGroup.append("path").attr("class","left values-line"),this.rightGroup.append("path").attr("class","right values-line"),this._x=null,this._y=null}A.prototype.style=function(e,t){return this.leftGroup.style(e,t),this.rightGroup.style(e,t),this},A.prototype.x=function(e){return null==e?this._x:(this._x=e,this)},A.prototype.y=function(e){return null==e?this._y:(this._y=e,this)},A.prototype.redraw=function(){const e=this._y.domain(),t=e[0],s=e[1],a=this._x.domain(),o=a[0],i=a[1],r=this,n=this.data.filter((function(e){return e.date<r.from})),l=this.data.filter((function(e){return e.date>r.to}));if(!0===this.drawBounds){const e=m().svg.area().x((function(e){return r._x(e.date)||1})).y0((function(e){return r._y(Math.min(s,Math.max(e.lower,t)))})).y1((function(e){return r._y(Math.max(t,Math.min(e.upper,s)))})).defined((e=>null!==e.lower&&null!==e.upper));this.leftGroup.select(".left.area.bounds").attr("d",e(n)),this.rightGroup.select(".right.area.bounds").attr("d",e(l))}const c=m().svg.line().x((function(e){return r._x(e.date)})).y((function(e){return r._y(e.value)})).defined((e=>null!==e.value));this.leftGroup.select(".left.values-line").attr("d",c(n)),(0,w.lj)(n,this.leftGroup,c,1),this.rightGroup.select(".right.values-line").attr("d",c(l)),(0,w.lj)(l,this.rightGroup,c,1);const u=this._x(o),d=this._y(t)+this.swimlaneHeight,h=this._x(this.from),p=this._x(this.to),f=this._y(t)+this.swimlaneHeight,g=this._x(i);return this.leftPolygon.attr("points",u+","+d+"  "+h+","+d+"  "+h+",0  "+u+",0"),this.rightPolygon.attr("points",p+","+f+"  "+g+","+f+"  "+g+",0  "+p+",0"),this},A.prototype.reveal=function(e){return this.from=e[0],this.to=e[1],this.redraw(),this};var C=s(90081),_=s(21069),T=s(18422);const I="mlAnnotationMask";function D(){const{annotationUpdatesService:e}=this.props,t=this.focusXScale,s=m().svg.brush().x(t).on("brushend",function(){const{selectedJob:t}=this.props,a=s.extent(),o=a[0].getTime(),i=a[1].getTime();if(o===i)return void e.setValue(null);const r={timestamp:o,end_timestamp:i,annotation:"",job_id:t.job_id,type:T.BQ.ANNOTATION};e.setValue(r)}.bind(this));return s}function N(e){const t={};return e.forEach(((s,a)=>{if(void 0!==s.key){const o=e.filter(((e,t)=>t<a));t[s.key]=o.reduce(((e,a)=>void 0===s.end_timestamp||void 0===a.end_timestamp||void 0===a.key||a.timestamp<s.timestamp&&a.end_timestamp<s.timestamp||a.timestamp>s.end_timestamp&&a.end_timestamp>s.end_timestamp?e:t[a.key]+1),0)}})),t}function O(e){m().selectAll(".ml-annotation").each((function(t){const s=m().select(this);t._id===e._id?s.selectAll(".ml-annotation__rect").classed("ml-annotation__rect--highlight",!0):(s.selectAll(".ml-annotation__text-rect").classed("ml-annotation__text-rect--blur",!0),s.selectAll(".ml-annotation__text").classed("ml-annotation__text--blur",!0),s.selectAll(".ml-annotation__rect").classed("ml-annotation__rect--blur",!0))}))}function P(){m().selectAll(".ml-annotation").each((function(){const e=m().select(this);e.selectAll(".ml-annotation__text-rect").classed("ml-annotation__text-rect--blur",!1),e.selectAll(".ml-annotation__rect").classed("ml-annotation__rect--highlight",!1).classed("ml-annotation__rect--blur",!1),e.selectAll(".ml-annotation__text").classed("ml-annotation__text--blur",!1)}))}var R=s(8414),B=s(72762),L=s(74494),z=s(39173),V=s(30538),W=s(96791);const X=350,Y=25,H=310,G=335,J=25,$=w.nD+4,U={top:10,right:10,bottom:15,left:40},q=[{duration:f().duration(1,"h"),label:"1h"},{duration:f().duration(12,"h"),label:"12h"},{duration:f().duration(1,"d"),label:"1d"},{duration:f().duration(1,"w"),label:"1w"},{duration:f().duration(2,"w"),label:"2w"},{duration:f().duration(1,"M"),label:"1M"}];function Z(e){const t=e<X?X:e,s=Math.round(.634*t);return{focusChartHeight:s,focusHeight:Y+s}}class TimeseriesChartIntl extends o.Component{constructor(e,t){super(e),(0,c.default)(this,"getTimeBuckets",void 0),(0,c.default)(this,"mlTimeSeriesExplorer",void 0),(0,c.default)(this,"rowMouseenterSubscriber",null),(0,c.default)(this,"rowMouseleaveSubscriber",null),(0,c.default)(this,"contextChartInitialized",!1),(0,c.default)(this,"drawContextBrush",(e=>{const{contextChartSelected:t}=this.props,s=this.brush,a=this.contextXScale,o=this.mask;s.x(a).on("brush",u).on("brushend",(function(){const e=s.empty()?a.domain():s.extent(),o=e[0].getTime(),i=e[1].getTime();void 0!==c.selectedBounds&&c.selectedBounds.min.valueOf()===o&&c.selectedBounds.max.valueOf()===i||(c.selectedBounds={min:f()(o),max:f()(i)},t({from:e[0],to:e[1]}))})),e.append("g").attr("class","x brush").call(s).selectAll("rect").attr("y",-1).attr("height",91).attr("width",this.vizWidth);const i=s.extent();e.selectAll(".w rect").attr("x",-10).attr("width",10),e.selectAll(".e rect").attr("transform",null).attr("width",10);const r=e.append("rect").attr("class","top-border").attr("y",-2).attr("height",3),n=e.append("foreignObject").attr("width",10).attr("height",90).attr("class","brush-handle").attr("x",a(i[0])-10).html('\n        <div class="brush-handle-inner brush-handle-inner-left" style="padding-top: 27px">\n          <svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="6" height="9">\n            <polygon points="5,0 5,8 0,4" />\n          </svg>\n        </div>'),l=e.append("foreignObject").attr("width",10).attr("height",90).attr("class","brush-handle").attr("x",a(i[1])+0).html('\n        <div class="brush-handle-inner brush-handle-inner-right" style="padding-top: 27px">\n          <svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="6" height="9">\n            <polygon points="0,0 0,8 5,4" />\n          </svg>\n        </div>'),c=this;function u(){const e=s.extent();o.reveal(e),n.attr("x",a(e[0])-10),l.attr("x",a(e[1])+0),r.attr("x",a(e[0])+1);const t=Math.max(0,a(e[1])-a(e[0])-2);r.attr("width",t);const i=s.empty();m().select(c.rootNode).selectAll(".brush-handle").style("visibility",i?"hidden":"visible")}u()})),(0,c.default)(this,"drawSwimlane",((e,t,s)=>{const{contextAggregationInterval:a,swimlaneData:o}=this.props,i=o;if(void 0===i)return;const r=this.calculateContextXAxisDomain(),n=m().time.scale().range([0,t]).domain(r),l=m().scale.linear().range([s,0]).domain([0,s]),c=m().svg.axis().scale(n).orient("bottom").innerTickSize(-s).outerTickSize(0),u=m().svg.axis().scale(l).orient("left").tickValues(l.domain()).innerTickSize(-t).outerTickSize(0),d=e.append("g");d.append("g").attr("class","x axis").attr("transform","translate(0,"+s+")").call(c),d.append("g").attr("class","y axis").call(u);const h=r[0].getTime();let p=t/((r[1].getTime()-h)/a.asMilliseconds());p<1&&(p=1),e.append("g").attr("class","swimlane-cells").selectAll("rect").data(i).enter().append("rect").attr("x",(e=>n(e.date))).attr("y",0).attr("rx",0).attr("ry",0).attr("class",(e=>e.score>0?"swimlane-cell":"swimlane-cell-hidden")).attr("width",p).attr("height",s).style("fill",(e=>this.props.anomalyColorScale(e.score)))})),(0,c.default)(this,"calculateContextXAxisDomain",(()=>{const{bounds:e,contextAggregationInterval:t,swimlaneData:s}=this.props;let a=e.min.valueOf();void 0!==s&&s.length>0&&(a=Math.min(s[0].date.getTime(),e.min.valueOf()));const o=t.asMilliseconds(),i=Math.floor(a/o)*o,r=Math.ceil(e.max.valueOf()/o)*o;return[new Date(i),new Date(r)]})),(0,c.default)(this,"setContextBrushExtent",((e,t)=>{const s=m().select(this.rootNode),a=this.brush,o=a.extent(),i=[e,t];a.extent(i),a(s.select(".brush")),i[0].getTime()===o[0].getTime()&&i[1].getTime()===o[1].getTime()||a.event(s.select(".brush"))})),(0,c.default)(this,"setShowRuleEditorFlyoutFunction",(e=>{this.setState({showRuleEditorFlyout:e})})),(0,c.default)(this,"unsetShowRuleEditorFlyoutFunction",(()=>{this.setState({showRuleEditorFlyout:()=>{}})})),(0,c.default)(this,"handleShowAnomalyAlertFlyout",(e=>{const t=(0,V.O)(e);this.setState({alertFlyoutParams:t,alertFlyoutVisible:!0})})),this.state={popoverData:null,popoverCoords:[0,0],showRuleEditorFlyout:()=>{},alertFlyoutVisible:!1,alertFlyoutParams:void 0},this.mlTimeSeriesExplorer=(0,C.timeSeriesExplorerServiceFactory)(t.services.uiSettings,t.services.mlServices.mlApi,t.services.mlServices.mlResultsService),this.getTimeBuckets=(0,k.E)(t.services.uiSettings).getTimeBuckets}componentWillUnmount(){m().select(this.rootNode).html(""),null!==this.rowMouseenterSubscriber&&this.rowMouseenterSubscriber.unsubscribe(),null!==this.rowMouseleaveSubscriber&&this.rowMouseleaveSubscriber.unsubscribe()}componentDidMount(){const{svgWidth:e,svgHeight:t}=this.props,{focusHeight:s,focusChartHeight:a}=t?Z(t):{};this.vizWidth=e-U.left-U.right;const o=this.vizWidth;this.focusXScale=m().time.scale().range([0,o]),this.focusYScale=m().scale.linear().range([null!=s?s:G,Y]);const i=this.focusXScale,r=this.focusYScale;this.focusXAxis=m().svg.axis().scale(i).orient("bottom").innerTickSize(-(null!=a?a:H)).outerTickSize(0).tickPadding(10),this.focusYAxis=m().svg.axis().scale(r).orient("left").innerTickSize(-o).outerTickSize(0).tickPadding(10),this.focusValuesLine=m().svg.line().x((function(e){return i(e.date)})).y((function(e){return r(e.value)})).defined((e=>null!==e.value)),this.focusBoundedArea=m().svg.area().x((function(e){return i(e.date)||1})).y0((function(e){return r(e.upper)})).y1((function(e){return r(e.lower)})).defined((e=>null!==e.lower&&null!==e.upper)),this.contextXScale=m().time.scale().range([0,o]),this.contextYScale=m().scale.linear().range([60,3]),this.fieldFormat=void 0,this.annotateBrush=D.call(this),this.brush=m().svg.brush(),this.mask=void 0;const n=this.highlightFocusChartAnomaly.bind(this),l=O.bind(this),c=this.unhighlightFocusChartAnomaly.bind(this),u=P.bind(this);this.rowMouseenterSubscriber=j.l.rowMouseenter$.subscribe(function({record:e,type:t="anomaly"}){null===this.state.popoverData&&("anomaly"===t?n(e):"annotation"===t&&l(e))}.bind(this)),this.rowMouseleaveSubscriber=j.l.rowMouseleave$.subscribe((function({record:e,type:t="anomaly"}){"anomaly"===t?c():u(e)})),this.renderChart(),this.drawContextChartSelection(),this.renderFocusChart()}componentDidUpdate(e){!1!==this.props.renderFocusChartOnly&&e.svgWidth===this.props.svgWidth&&e.showAnnotations===this.props.showAnnotations&&e.annotationData===this.props.annotationData||(this.renderChart(),this.drawContextChartSelection()),this.renderFocusChart(),null===this.props.annotation&&m().select(this.rootNode).select("g.ml-annotation__brush").call(this.annotateBrush.extent([0,0]))}renderChart(){const{contextChartData:e,contextForecastData:t,detectorIndex:s,modelPlotEnabled:a,selectedJob:o,svgWidth:i,svgHeight:r,showAnnotations:n}=this.props,l=this.createFocusChart.bind(this),c=this.drawContextElements.bind(this),u=this.focusXScale,d=this.focusYAxis,h=this.focusYScale,p=function(e,t){const s=e?$:0,a=t&&t<X?X:t,{focusHeight:o}=t?Z(a):{};return(null!=o?o:G)+60+30+s+J+U.top+U.bottom}(n,r),{focusHeight:f}=r?Z(r):{},g=m().select(this.rootNode);if(g.selectAll("*").remove(),void 0===o)return;if(this.fieldFormat=this.context.services.mlServices.mlFieldFormatService.getFieldFormat(o.job_id,s),void 0===e)return;const x=this.fieldFormat,v=g.append("svg").attr("width",i).attr("height",p);let b,y;if(!0===a||void 0!==t&&t.length>0){const s=void 0===t?e:e.concat(t);b=m().min(s,(e=>Math.min(e.value,e.lower))),y=m().max(s,(e=>Math.max(e.value,e.upper)))}else b=m().min(e,(e=>e.value)),y=m().max(e,(e=>e.value));const S=y>0?Math.pow(10,Math.ceil(Math.log10(Math.abs(y)))):y,M=b>=0?b:-1*Math.pow(10,Math.ceil(Math.log10(Math.abs(b))));h.domain([M,S]);let F=0;v.append("g").attr("class","temp-axis-label tick").selectAll("text.temp.axis").data(h.ticks()).enter().append("text").text((e=>void 0!==x?x.convert(e,"text"):h.tickFormat()(e))).each((function(){F=Math.max(this.getBBox().width+d.tickPadding(),F)})).remove(),g.select(".temp-axis-label").remove(),U.left=Math.max(F,40),this.vizWidth=Math.max(i-U.left-U.right,0),u.range([0,this.vizWidth]),d.innerTickSize(-this.vizWidth),void 0!==f&&h.range([f,Y]);const E=v.append("g").attr("class","focus-chart").attr("transform","translate("+U.left+","+U.top+")"),w=v.append("g").attr("class","context-chart").attr("transform","translate("+U.left+","+((null!=f?f:G)+U.top+J)+")");v.append("defs").append("mask").attr("id",I).append("rect").attr("x",0).attr("y",0).attr("width",this.vizWidth).attr("height",null!=f?f:G).style("fill","white"),l(E,this.vizWidth,null!=f?f:G),c(w,this.vizWidth,60,30,$)}drawContextChartSelection(){const{contextChartData:e,contextForecastData:t,zoomFrom:s,zoomTo:a}=this.props;if(void 0===e)return;let o,i;const r=this.contextXScale.domain()[0].getTime(),n=this.contextXScale.domain()[1].getTime();let l=e;if(void 0!==t&&(l=l.concat(t)),o=s?s.getTime():(0,d.reduce)(l,((e,t)=>Math.min(e,t.date.getTime())),new Date(2099,12,31).getTime()),o=Math.max(o,r),i=a?a.getTime():(0,d.reduce)(l,((e,t)=>Math.max(e,t.date.getTime())),0),i=Math.min(i,n),o!==r||i!==n){this.setContextBrushExtent(new Date(o),new Date(i));const e={min:f()(new Date(o)),max:f()(o)};this.selectedBounds=e}else{const e=this.contextXScale.domain(),t={min:f()(new Date(e[0])),max:f()(e[1])};(0,d.isEqual)(t,this.selectedBounds)||(this.selectedBounds=t,this.setContextBrushExtent(new Date(e[0]),new Date(e[1])))}}createFocusChart(e,t,s){const{contextForecastData:a}=this.props,{focusChartHeight:o}=this.props.svgHeight?Z(this.props.svgHeight):{},i=e.append("g").attr("class","focus-zoom");i.append("rect").attr("x",0).attr("y",0).attr("width",t).attr("height",Y).attr("class","chart-border"),this.createZoomInfoElements(i,t);const r=this.annotateBrush.bind(this);let n=0,l=0;null!==this.props.annotation&&(n=this.focusXScale(this.props.annotation.timestamp),l=function(e,t){const s=t(e.timestamp)+1,a=void 0!==e.end_timestamp?t(e.end_timestamp)-1:s+8;return Math.max(8,a-s)}(this.props.annotation,this.focusXScale)),e.append("g").attr("class","ml-annotation__brush").call(r).selectAll("rect").attr("x",n).attr("y",Y).attr("width",l).attr("height",null!=o?o:H),e.append("g").classed("ml-annotations",!0),e.append("rect").attr("x",0).attr("y",Y).attr("width",t).attr("height",null!=o?o:H).attr("class","chart-border");const c=e.append("g").attr("class","x-axis-background");c.append("rect").attr("x",0).attr("y",s).attr("width",t).attr("height",J),c.append("line").attr("x1",0).attr("y1",s).attr("x2",0).attr("y2",s+J),c.append("line").attr("x1",t).attr("y1",s).attr("x2",t).attr("y2",s+J),c.append("line").attr("x1",0).attr("y1",s+J).attr("x2",t).attr("y2",s+J);const u=e.append("g");u.append("g").attr("class","x axis").attr("transform","translate(0,"+s+")"),u.append("g").attr("class","y axis"),e.append("path").attr("class","area bounds"),e.append("path").attr("class","values-line"),e.append("g").attr("class","focus-chart-markers"),a&&(e.append("path").attr("class","area forecast").attr("data-test-subj","mlForecastArea"),e.append("path").attr("class","values-line forecast").attr("data-test-subj","mlForecastValuesline"),e.append("g").attr("class","focus-chart-markers forecast").attr("data-test-subj","mlForecastMarkers")),e.append("rect").attr("x",0).attr("y",0).attr("width",t).attr("height",s+24).attr("class","chart-border chart-border-highlight")}renderFocusChart(){const{embeddableMode:e,focusAggregationInterval:t,focusAnnotationData:s,focusChartData:a,focusForecastData:o,modelPlotEnabled:i,selectedJob:n,showAnnotations:l,showForecast:c,showModelBounds:u,zoomFromFocusLoaded:d,zoomToFocusLoaded:h}=this.props,p=Array.isArray(s)?s:[];if(void 0===a)return;const g=a,v=this.contextYScale,b=this.showAnomalyPopover.bind(this),y=this.showFocusChartTooltip.bind(this),S=this.props.tooltipService.hide.bind(this.props.tooltipService),M=m().select(this.rootNode),F=M.select(".focus-chart"),E=t.expression,k=n.analysis_config.bucket_span;if(M.select(".zoom-aggregation-interval").text(r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.zoomAggregationIntervalLabel",{defaultMessage:"(aggregation interval: {focusAggInt}, bucket span: {bucketSpan})",values:{focusAggInt:E,bucketSpan:k}})),void 0===d||void 0===h)return;const j={min:f()(d.getTime()),max:f()(h.getTime())},A=t.asMilliseconds(),C=f()(Math.floor(j.min.valueOf()/A)*A),_=f()(Math.ceil(j.max.valueOf()/A)*A);if(this.focusXScale.domain([C.toDate(),_.toDate()]),a.length>0||void 0!==o&&o.length>0){void 0!==this.fieldFormat?this.focusYAxis.tickFormat((e=>this.fieldFormat.convert(e,"text"))):this.focusYAxis.tickFormat(null);let e=0,t=0,s=g;if(c&&void 0!==o&&o.length>0&&(s=g.concat(o)),e=m().min(s,(e=>{let t=e.value;return null===t&&void 0!==e.anomalyScore&&void 0!==e.actual&&(t=Array.isArray(e.actual)?e.actual[0]:e.actual),void 0!==e.lower?null!=t?Math.min(t,e.lower):e.lower:t||0})),t=m().max(s,(e=>{let t=e.value;return null===t&&void 0!==e.anomalyScore&&void 0!==e.actual&&(t=Array.isArray(e.actual)?e.actual[0]:e.actual),void 0!==e.upper?Math.max(t,e.upper):t||0})),t===e&&(this.contextYScale.domain()[0]!==v.domain()[1]&&e>=v.domain()[0]&&t<=v.domain()[1]?(e=v.domain()[0],t=v.domain()[1]):(e-=.05*e,t+=.05*t)),l&&p&&p.length>0){const s=N(p),a=m().max(Object.keys(s).map((e=>s[e])));t+=Math.abs(t-e)*((a+1)/5)}this.focusYScale.domain([e,t])}else this.focusYScale.domain([0,10]),this.focusYAxis.tickFormat("");const T=this.getTimeBuckets();T.setInterval("auto"),T.setBounds(j);const D=T.getScaledDateFormat();F.select(".x.axis").call(this.focusXAxis.ticks((0,w.Vc)(this.vizWidth),D).tickFormat((e=>f()(e).format(D)))),F.select(".y.axis").call(this.focusYAxis),(0,w.PF)(F.select(".x.axis"),this.vizWidth),!0===i&&F.select(".area.bounds").attr("d",this.focusBoundedArea(g)).classed("hidden",!u);const{focusChartHeight:O,focusHeight:P}=this.props.svgHeight?Z(this.props.svgHeight):{};!function(e,t,s,a,o,i,r,n,l){const c={};t.forEach((e=>{if(void 0!==e.key){const t=(e.end_timestamp||0)-e.timestamp;c[e.key]=t}})),t.sort(((e,t)=>void 0===e.key||void 0===t.key?0:c[t.key]-c[e.key]));const u=N(t),d=function(e){r(e,this)},h=e=>{l.setValue(null),l.setValue(e)},m=e.select(".ml-annotations").selectAll("g.ml-annotation").data(t||[],(e=>e._id||""));m.enter().append("g").classed("ml-annotation",!0);const p=m.selectAll(".ml-annotation__rect").data((e=>[e]));p.enter().append("rect").classed("ml-annotation__rect",!0).attr("mask",`url(#${I})`).on("mouseover",d).on("mouseout",n).on("click",h),p.attr("x",(e=>{const t=f()(e.timestamp);return Math.max(o(t),0)})).attr("y",(e=>26+28*(void 0!==e.key?u[e.key]:1))).attr("height",(e=>{const t=void 0!==e.key?u[e.key]:1;return a-2-0-28*t})).attr("width",(e=>{const t=o(f()(e.timestamp))+1,s=void 0!==e.end_timestamp?o(f()(e.end_timestamp))-1:t+8;return Math.max(8,s-t)})),p.exit().remove();const g=m.selectAll(".ml-annotation__text-rect").data((e=>[e])),x=m.selectAll(".ml-annotation__text").data((e=>[e]));function v(e){const t=o.domain()[0],s=o.domain()[1],a=f()(e),i=Math.max(o(t),o(a));return Math.min(o(s)-32,i)}g.enter().append("rect").classed("ml-annotation__text-rect",!0).attr("width",24).attr("height",20).on("mouseover",d).on("mouseout",n).on("click",h),x.enter().append("text").classed("ml-annotation__text",!0).on("mouseover",d).on("mouseout",n).on("click",h),x.attr("x",(e=>v(e.timestamp)+17)).attr("y",(e=>44+28*(void 0!==e.key?u[e.key]:1))).text((e=>e.key)),g.attr("x",(e=>v(e.timestamp)+5)).attr("y",(e=>30+28*(void 0!==e.key?u[e.key]:1))),g.exit().remove(),x.exit().remove(),m.classed("ml-annotation--hidden",!i),m.exit().remove()}(F,p,0,null!=O?O:H,this.focusXScale,l,y,S,this.props.annotationUpdatesService),F.select(".ml-annotation__brush").style("display",!l||e?"none":null),F.select(".values-line").attr("d",this.focusValuesLine(g)),(0,w.lj)(g,F,this.focusValuesLine);const R=M.select(".focus-chart-markers").selectAll(".metric-value").data(g.filter((e=>(null!==e.value||"number"==typeof e.anomalyScore)&&!(0,w.A4)(e)))),B=this;R.exit().remove(),R.enter().append("circle").attr("r",w.$d).on("click",(function(e){m().event.preventDefault(),void 0!==e.anomalyScore&&b(e,this)})).on("mouseover",(function(e){null===B.state.popoverData&&y(e,this)})).on("mouseout",(()=>this.props.tooltipService.hide())),R.attr("cx",(e=>this.focusXScale(e.date))).attr("cy",(e=>this.focusYScale(e.value))).attr("data-test-subj",(e=>void 0!==e.anomalyScore?"mlAnomalyMarker":void 0)).attr("class",(e=>{let t="metric-value";return void 0!==e.anomalyScore&&(t+=` anomaly-marker ${(0,x.AI)(e.anomalyScore).id}`),t}));const L=M.select(".focus-chart-markers").selectAll(".multi-bucket").data(g.filter((e=>null!==e.anomalyScore&&!0===(0,w.A4)(e))));L.exit().remove(),L.enter().append("path").attr("d",m().svg.symbol().size(w.wK).type("cross")).on("click",(function(e){m().event.preventDefault(),void 0!==e.anomalyScore&&b(e,this)})).on("mouseover",(function(e){y(e,this)})).on("mouseout",(()=>this.props.tooltipService.hide())),L.attr("transform",(e=>`translate(${this.focusXScale(e.date)}, ${this.focusYScale(e.value)})`)).attr("data-test-subj","mlAnomalyMarker").attr("class",(e=>`anomaly-marker multi-bucket ${(0,x.AI)(e.anomalyScore).id}`));const z=M.select(".focus-chart-markers").selectAll(".scheduled-event-marker").data(g.filter((e=>void 0!==e.scheduledEvents)));if(z.exit().remove(),z.enter().append("rect").on("mouseover",(function(e){y(e,this)})).on("mouseout",(()=>S())).attr("width",2*w.$d).attr("height",w.Kv).attr("class","scheduled-event-marker").attr("rx",1).attr("ry",1),z.attr("x",(e=>this.focusXScale(e.date)-w.$d)).attr("y",(e=>{const t=this.focusYScale(e.value);return isNaN(t)?-(null!=P?P:G)-3:t-3})),void 0!==o){F.select(".area.forecast").attr("d",this.focusBoundedArea(o)).classed("hidden",!c),F.select(".values-line.forecast").attr("d",this.focusValuesLine(o)).classed("hidden",!c);const e=M.select(".focus-chart-markers.forecast").selectAll(".metric-value").data(o);e.exit().remove(),e.enter().append("circle").attr("r",w.$d).on("mouseover",(function(e){y(e,this)})).on("mouseout",(()=>this.props.tooltipService.hide())),e.attr("cx",(e=>this.focusXScale(e.date))).attr("cy",(e=>this.focusYScale(e.value))).attr("class","metric-value").classed("hidden",!c)}}createZoomInfoElements(e,t){const{autoZoomDuration:s,bounds:a,modelPlotEnabled:o}=this.props,i=this.setZoomInterval.bind(this),n=a.max.unix()-a.min.unix(),l=10/this.vizWidth*n;let c=10;const u=e.append("text").attr("x",c).attr("y",17).attr("class","zoom-info-text").text(r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.zoomLabel",{defaultMessage:"Zoom:"})),h=[{durationMs:s,label:"auto"}];if((0,d.each)(q,(e=>{e.duration.asSeconds()>l&&e.duration.asSeconds()<n&&h.push({durationMs:e.duration.asMilliseconds(),label:e.label})})),c+=u.node().getBBox().width+4,(0,d.each)(h,(t=>{const s=e.append("a").attr("data-ms",t.durationMs).attr("href","").append("text").attr("x",c).attr("y",17).attr("class","zoom-info-text").text(t.label);c+=s.node().getBBox().width+4})),e.append("text").attr("x",c+6).attr("y",17).attr("class","zoom-info-text zoom-aggregation-interval").text(r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.zoomGroupAggregationIntervalLabel",{defaultMessage:"(aggregation interval: , bucket span: )"})),!1===o){const s=e.append("text").attr("x",300).attr("y",17).attr("class","zoom-info-text").text(r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.modelBoundsNotAvailableLabel",{defaultMessage:"Model bounds are not available"}));s.attr("x",t-(s.node().getBBox().width+10))}m().select(this.rootNode).selectAll(".focus-zoom a").on("click",(function(){m().event.preventDefault(),i(this.getAttribute("data-ms"))}))}drawContextElements(e,t,s,a){const{bounds:o,contextChartData:i,contextForecastData:r,modelPlotEnabled:n,annotationData:l}=this.props,c=i,u=Array.isArray(l)?[...l].sort(((e,t)=>e.timestamp-t.timestamp)):[];let h=[];if(u.length>0){h=[{start:u[0].timestamp,end:u[0].end_timestamp,annotations:[u[0]]}];let e=u[0].end_timestamp;for(let t=1;t<u.length;t++){if(u[t].timestamp<e){const s=h.pop(),a={...s,end:e,annotations:[...s.annotations,u[t]]};h.push(a)}else h.push({start:u[t].timestamp,end:u[t].end_timestamp,annotations:[u[t]]});e=u[t].end_timestamp}}const p=this.showFocusChartTooltip.bind(this),g=this.props.tooltipService.hide.bind(this.props.tooltipService);this.contextXScale=m().time.scale().range([0,t]).domain(this.calculateContextXAxisDomain());const x=void 0===r?c:c.concat(r),v={min:Number.MAX_VALUE,max:Number.MIN_VALUE};(0,d.each)(x,(e=>{var t,s;const a=null!==(t=e.lower)&&void 0!==t?t:Number.MAX_VALUE,o=null!==(s=e.upper)&&void 0!==s?s:Number.MIN_VALUE;v.min=Math.min(e.value,a,v.min),v.max=Math.max(e.value,o,v.max)}));let b=v.min,y=v.max;const S={min:b,max:y};if(!0===n||void 0!==r&&r.length>0){const e={min:Number.MAX_VALUE,max:Number.MIN_VALUE};(0,d.each)(x,(t=>{e.min=Math.min(t.lower,e.min),e.max=Math.max(t.upper,e.max)})),b=Math.min(b,e.min),y=Math.max(y,e.max),v.max-v.min<.5*(y-b)&&(v.min>b&&(S.min=v.min-.5*(v.max-v.min)),v.max<y&&(S.max=v.max+.5*(v.max-v.min)))}this.contextYScale=m().scale.linear().range([s,3]).domain([S.min,S.max]);const M=e.append("g").attr("class","axis"),F=s+a+$;M.append("line").attr("x1",0).attr("y1",0).attr("x2",0).attr("y2",F),M.append("line").attr("x1",t).attr("y1",0).attr("x2",t).attr("y2",F),M.append("line").attr("x1",0).attr("y1",F).attr("x2",t).attr("y2",F);const E=this.getTimeBuckets();E.setInterval("auto"),E.setBounds(o);const k=E.getScaledDateFormat(),j=m().svg.axis().scale(this.contextXScale).orient("top").innerTickSize(-s).outerTickSize(0).tickPadding(0).ticks((0,w.Vc)(t,k)).tickFormat((e=>f()(e).format(k)));e.datum(c);const C=m().svg.area().x((e=>this.contextXScale(e.date))).y0((e=>this.contextYScale(Math.min(S.max,Math.max(e.lower,S.min))))).y1((e=>this.contextYScale(Math.max(S.min,Math.min(e.upper,S.max))))).defined((e=>null!==e.lower&&null!==e.upper));!0===n&&e.append("path").datum(c).attr("class","area bounds").attr("d",C);const _=m().svg.line().x((e=>this.contextXScale(e.date))).y((e=>this.contextYScale(e.value))).defined((e=>null!==e.value));e.append("path").datum(c).attr("class","values-line").attr("d",_),(0,w.lj)(c,e,_,1),e.append("g").classed("ml-annotation__context",!0);const[T,I]=this.contextXScale.range(),D=e.select(".ml-annotation__context").selectAll("g.ml-annotation__context-item").data(h,(e=>`${e.start}-${e.end}`||""));D.enter().append("g").classed("ml-annotation__context-item",!0);const N=D.selectAll(".ml-annotation__context-rect").data((e=>[e]));N.enter().append("rect").on("mouseover",(function(e){p(1===e.annotations.length?e.annotations[0]:e,this)})).on("mouseout",(()=>g())).classed("ml-annotation__context-rect",!0),N.attr("x",(e=>{const t=f()(e.start);let s=this.contextXScale(t);return s-w.nD<=T&&(s=0),s+w.nD>=I&&(s=I-w.nD),s})).attr("y",s+a+2).attr("height",w.nD).attr("width",(e=>{const t=Math.max(this.contextXScale(f()(e.start))+1,T),s=Math.min(I,void 0!==e.end?this.contextXScale(f()(e.end))-1:t+8);return Math.max(8,s-t)})),N.exit().remove(),void 0!==r&&(e.append("path").datum(r).attr("class","area forecast").attr("d",C),e.append("path").datum(r).attr("class","values-line forecast").attr("d",_));const O=e.append("g").attr("class","swimlane").attr("transform","translate(0,"+s+")");this.drawSwimlane(O,t,a),this.mask=new A(e,i,n,a).x(this.contextXScale).y(this.contextYScale),e.append("g").attr("class","x axis context-chart-axis").call(j),e.selectAll(".x.context-chart-axis text").attr("dy",s-5),(0,w.PF)(e.selectAll(".x.context-chart-axis"),t),this.drawContextBrush(e)}setZoomInterval(e){const{bounds:t,zoomTo:s}=this.props,a=t.min.valueOf(),o=t.max.valueOf(),i=+e;let r=s.getTime(),n=r-i;n<a&&(n=a,r=Math.min(a+i,o)),this.setContextBrushExtent(new Date(n),new Date(r))}showAnomalyPopover(e,t){const s=e.date.getTime(),a=(0,F.O)(this.props.tableData.anomalies,s);if(a){a.source.timestamp=s;const e=t.getBoundingClientRect(),o=this.rootNode.getBoundingClientRect(),i=Math.round(e.x+e.width/2-o.x),r=Math.round(e.y+e.height/2-o.y)-28;this.props.tooltipService.hide(),this.setState({popoverData:a,popoverCoords:[i,r]})}}showFocusChartTooltip(e,t){var s;const{modelPlotEnabled:a}=this.props,o=this.fieldFormat,i="single_metric_viewer",n=[{label:(0,S.v_)(e.date)}];if(void 0!==e.anomalyScore){const t=parseInt(e.anomalyScore);if(n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.anomalyScoreLabel",{defaultMessage:"anomaly score"}),value:(0,v.m)(t),color:this.props.anomalyColorScale(t),seriesIdentifier:{key:i},valueAccessor:"anomaly_score"}),!0===(0,w.pn)(e)&&n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.multiBucketAnomalyLabel",{defaultMessage:"multi-bucket impact"}),value:(0,w.gX)(e),seriesIdentifier:{key:i},valueAccessor:"multi_bucket_impact"}),e.metricFunction&&n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.metricActualPlotFunctionLabel",{defaultMessage:"function"}),value:e.metricFunction,seriesIdentifier:{key:i},valueAccessor:"metric_function"}),!1===a){if(void 0!==e.actual&&"rare"!==e.function)n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.actualLabel",{defaultMessage:"actual"}),value:(0,E.Fl)(e.actual,e.function,o),seriesIdentifier:{key:i},valueAccessor:"actual"}),n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.typicalLabel",{defaultMessage:"typical"}),value:(0,E.Fl)(e.typical,e.function,o),seriesIdentifier:{key:i},valueAccessor:"typical"});else if(void 0!==e.value&&n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.valueLabel",{defaultMessage:"value"}),value:(0,E.Fl)(e.value,e.function,o),seriesIdentifier:{key:i},valueAccessor:"value"}),void 0!==e.byFieldName&&void 0!==e.numberOfCauses){const t=e.numberOfCauses,s=(0,_.lt)(e.byFieldName);n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.moreThanOneUnusualByFieldValuesLabel",{defaultMessage:"{numberOfCauses}{plusSign} unusual {byFieldName} values",values:{numberOfCauses:t,byFieldName:s,plusSign:t<10?"":"+"}}),seriesIdentifier:{key:i},valueAccessor:"numberOfCauses"})}}else e.annotations||(n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.modelPlotEnabled.actualLabel",{defaultMessage:"actual"}),value:(0,E.Fl)(e.actual,e.function,o),seriesIdentifier:{key:i},valueAccessor:"actual"}),n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.modelPlotEnabled.upperBoundsLabel",{defaultMessage:"upper bounds"}),value:(0,E.Fl)(e.upper,e.function,o),seriesIdentifier:{key:i},valueAccessor:"upper_bounds"}),n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.modelPlotEnabled.lowerBoundsLabel",{defaultMessage:"lower bounds"}),value:(0,E.Fl)(e.lower,e.function,o),seriesIdentifier:{key:i},valueAccessor:"lower_bounds"}))}else!0===(0,d.get)(e,"isForecast",!1)?n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.withoutAnomalyScore.predictionLabel",{defaultMessage:"prediction"}),value:(0,E.Fl)(e.value,e.function,o),seriesIdentifier:{key:i},valueAccessor:"prediction"}):void 0!==e.value&&null!==e.value&&n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.withoutAnomalyScore.valueLabel",{defaultMessage:"value"}),value:(0,E.Fl)(e.value,e.function,o),seriesIdentifier:{key:i},valueAccessor:"value"}),e.annotations||!0!==a||(n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.withoutAnomalyScoreAndModelPlotEnabled.upperBoundsLabel",{defaultMessage:"upper bounds"}),value:(0,E.Fl)(e.upper,e.function,o),seriesIdentifier:{key:i},valueAccessor:"upper_bounds"}),n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.withoutAnomalyScoreAndModelPlotEnabled.lowerBoundsLabel",{defaultMessage:"lower bounds"}),value:(0,E.Fl)(e.lower,e.function,o),seriesIdentifier:{key:i},valueAccessor:"lower_bounds"}));if(void 0!==e.scheduledEvents&&e.scheduledEvents.forEach(((t,s)=>{n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.scheduledEventsLabel",{defaultMessage:"scheduled event{counter}",values:{counter:e.scheduledEvents.length>1?` #${s+1}`:""}}),value:t,seriesIdentifier:{key:i},valueAccessor:`scheduled_events_${s+1}`})})),void 0!==e.annotation){n.length=0,n.push({label:e.annotation});let t=f()(e.timestamp).format("MMMM Do YYYY, HH:mm");void 0!==e.end_timestamp&&(t+=` - ${f()(e.end_timestamp).format("MMMM Do YYYY, HH:mm")}`),n.push({label:t,seriesIdentifier:{key:i},valueAccessor:"timespan"})}(null===(s=e.annotations)||void 0===s?void 0:s.length)>1&&e.annotations.forEach((e=>{var t;let s=f()(e.timestamp).format("MMMM Do YYYY, HH:mm");void 0!==e.end_timestamp&&(s+=` - ${f()(e.end_timestamp).format("HH:mm")}`),n.push({label:s,value:`${e.annotation}`,seriesIdentifier:{key:"anomaly_timeline",specId:null!==(t=e._id)&&void 0!==t?t:`${e.annotation}-${e.timestamp}-label`},valueAccessor:"annotation"})}));let l=2*w.$d;if("rect"===t.tagName.toLowerCase()){const e=Number(t.getAttribute("x"));e<0&&(l=Math.abs(e))}this.props.tooltipService.show(n,t,{x:l,y:0})}highlightFocusChartAnomaly(e){const{focusChartData:t,focusAggregationInterval:s}=this.props,a=this.focusXScale,o=this.focusYScale,i=this.showFocusChartTooltip.bind(this),r=e.source.timestamp,n=this.mlTimeSeriesExplorer.findChartPointForAnomalyTime(t,r,s),l=m().select(this.rootNode);if(void 0!==n){const e=l.select(".focus-chart-markers").selectAll(".focus-chart-highlighted-marker").data([n]);!0===(0,w.A4)(n)?e.enter().append("path").attr("d",m().svg.symbol().size(w.wK).type("cross")).attr("transform",(e=>`translate(${a(e.date)}, ${o(e.value)})`)).attr("data-test-subj","mlAnomalyMarker").attr("class",(e=>`anomaly-marker multi-bucket ${(0,x.AI)(e.anomalyScore).id} highlighted`)):e.enter().append("circle").attr("r",w.$d).attr("cx",(e=>a(e.date))).attr("cy",(e=>o(e.value))).attr("data-test-subj","mlAnomalyMarker").attr("class",(e=>`anomaly-marker metric-value ${(0,x.AI)(e.anomalyScore).id} highlighted`));const t=l.selectAll(".focus-chart-markers .anomaly-marker.highlighted");t.length&&i(n,t[0][0])}}unhighlightFocusChartAnomaly(){m().select(this.rootNode).select(".focus-chart-markers").selectAll(".anomaly-marker.highlighted").remove(),this.props.tooltipService.hide()}shouldComponentUpdate(){return!0}setRef(e){this.rootNode=e}closePopover(){this.setState({popoverData:null,popoverCoords:[0,0]})}render(){return(0,W.jsx)(i().Fragment,null,(0,W.jsx)(L.z,{selectedJob:this.props.selectedJob,setShowFunction:this.setShowRuleEditorFlyoutFunction,unsetShowFunction:this.unsetShowRuleEditorFlyoutFunction}),this.state.alertFlyoutVisible&&this.state.alertFlyoutParams&&(0,W.jsx)(z.sU,{onCloseFlyout:()=>this.setState({alertFlyoutVisible:!1}),initialParams:this.state.alertFlyoutParams}),null!==this.state.popoverData&&(0,W.jsx)("div",{style:{position:"absolute",marginLeft:this.state.popoverCoords[0],marginTop:this.state.popoverCoords[1]}},(0,W.jsx)(g.EuiPopover,{isOpen:!0,closePopover:()=>this.closePopover(),panelPaddingSize:"none",anchorPosition:"upLeft"},(0,W.jsx)(B.F,{anomaly:this.state.popoverData,selectedJob:this.props.selectedJob,bounds:this.props.bounds,showMapsLink:!1,showViewSeriesLink:!1,isAggregatedData:"second"!==this.props.tableData.interval,interval:this.props.tableData.interval,showRuleEditorFlyout:this.state.showRuleEditorFlyout,showAnomalyAlertFlyout:this.handleShowAnomalyAlertFlyout,onItemClick:()=>this.closePopover(),sourceIndicesWithGeoFields:this.props.sourceIndicesWithGeoFields}))),(0,W.jsx)("div",{className:"ml-timeseries-chart-react",ref:this.setRef.bind(this)}))}}(0,c.default)(TimeseriesChartIntl,"contextType",M.context);const K=e=>{const t=(0,o.useContext)(R.m),s=(0,u.A)(t.isAnnotationInitialized$()),{euiTheme:i}=(0,g.useEuiTheme)(),r=(0,o.useMemo)((()=>m().scale.threshold().domain([b.I.WARNING,b.I.MINOR,b.I.MAJOR,b.I.CRITICAL]).range([(0,y.CP)(b.I.LOW,i),(0,y.CP)(b.I.WARNING,i),(0,y.CP)(b.I.MINOR,i),(0,y.CP)(b.I.MAJOR,i),(0,y.CP)(b.I.CRITICAL,i)])),[i]);return void 0===s?null:(0,W.jsx)(TimeseriesChartIntl,(0,a.default)({annotation:s,anomalyColorScale:r},e,{annotationUpdatesService:t}))};var Q=s(42678),ee=s(67140),te=s(56509);const se=({bounds:e,detectorIndex:t,embeddableMode:s,renderFocusChartOnly:i,selectedJob:c,selectedEntities:u,showAnnotations:d,showForecast:h,showModelBounds:m,chartProps:p,lastRefresh:f,contextAggregationInterval:g,tableData:x={anomalies:[],interval:"second"},sourceIndicesWithGeoFields:v})=>{const{toasts:b}=(0,ee.E$)(),{services:{mlServices:{mlApi:y}}}=(0,ee.hk)(),S=(0,o.useContext)(R.m),[M,F]=(0,o.useState)([]),E=(0,o.useCallback)((e=>{b.addDanger({title:r.i18n.translate("xpack.ml.timeSeriesExplorer.mlSingleMetricViewerChart.annotationsErrorTitle",{defaultMessage:"An error occurred fetching annotations"}),...e?{text:(0,n.P)(e)}:{}})}),[]),w=(0,k.t)();return(0,o.useEffect)((()=>{let s=!1;const a=(0,te.s)(t,u,c),o=Array.isArray(a)?a.filter((e=>null!==e.fieldValue)):void 0,i=w.getBoundsRoundedToInterval(e,g,!1);return(async e=>{try{const a=await y.annotations.getAnnotations({jobIds:[e],earliestMs:i.min.valueOf(),latestMs:i.max.valueOf(),maxAnnotations:Q.b,detectorIndex:t,entities:o});s||Array.isArray(a.annotations[e])&&F(a.annotations[e])}catch(e){E(e)}})(c.job_id),()=>{s=!0}}),[c.job_id,t,f,u,e,g]),p.svgHeight&&(p.svgHeight-=32),(0,W.jsx)("div",{className:"ml-timeseries-chart","data-test-subj":"mlSingleMetricViewerChart"},(0,W.jsx)(l.Y,null,(o=>(0,W.jsx)(K,(0,a.default)({},p,{annotationUpdatesService:S,annotationData:M,bounds:e,detectorIndex:t,embeddableMode:s,renderFocusChartOnly:i,selectedJob:c,showAnnotations:d,showForecast:h,showModelBounds:m,tooltipService:o,tableData:x,sourceIndicesWithGeoFields:v})))))}},23289:(e,t,s)=>{s.d(t,{i:()=>i});var a=s(81319),o=(s(84286),s(96791));const i=({errorMsg:e})=>(0,o.jsx)(a.EuiEmptyPrompt,{iconType:"warning",title:(0,o.jsx)("h2",null,e)})},49183:(e,t,s)=>{s.d(t,{H:()=>r}),s(84286);var a=s(81319),o=s(75008),i=s(96791);const r=({dataNotChartable:e,entities:t})=>(0,i.jsx)(a.EuiEmptyPrompt,{iconType:"info",title:(0,i.jsx)("h2",null,o.i18n.translate("xpack.ml.timeSeriesExplorer.noResultsFoundLabel",{defaultMessage:"No results found"})),body:e?(0,i.jsx)("p",null,o.i18n.translate("xpack.ml.timeSeriesExplorer.dataNotChartableDescription",{defaultMessage:"Model plot is not collected for the selected {entityCount, plural, one {entity} other {entities}}\nand the source data cannot be plotted for this detector.",values:{entityCount:t.length}})):(0,i.jsx)("p",null,o.i18n.translate("xpack.ml.timeSeriesExplorer.tryWideningTheTimeSelectionDescription",{defaultMessage:"Try widening the time selection or moving further back in time."}))})},82690:(e,t,s)=>{s.d(t,{U:()=>n}),s(84286);var a=s(75008),o=s(75879),i=s(23835),r=s(96791);const n=({embeddableMode:e})=>(0,r.jsx)(i.U,{anchorPosition:"upCenter",title:a.i18n.translate("xpack.ml.timeSeriesExplorer.popoverTitle",{defaultMessage:"Single time series analysis"})},(0,r.jsx)("p",null,(0,r.jsx)(o.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.popoverBasicExplanation",defaultMessage:"This chart illustrates the actual data values over time for a specific detector. You can examine an event by sliding the time selector and changing its length. For the most accurate view, set the zoom size to auto."})),(0,r.jsx)("p",null,(0,r.jsx)(o.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.popoverAnomalyExplanation",defaultMessage:"An anomaly score is calculated for each bucket time interval, with a value from 0 to 100. Anomalous events are highlighted in colors that indicate their severity. If an anomaly is depicted with a cross symbol instead of a dot, it has a moderate, significant, or high multi-bucket impact. This extra analysis can catch anomalies even when they fall within the bounds of expected behavior."})),(0,r.jsx)("p",null,(0,r.jsx)(o.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.popoverForecastExplanation",defaultMessage:"If you create a forecast, predicted data values are added to the chart. A shaded area around these values represents the confidence level; as you forecast further into the future, the confidence level generally decreases."})),!e&&(0,r.jsx)("p",null,(0,r.jsx)(o.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.popoverAnnotationsExplanation",defaultMessage:"You can also optionally annotate your job results by drag-selecting a period of time in the chart and adding a description. Some annotations are generated automatically to indicate noteworthy occurrences."})),(0,r.jsx)("p",null,(0,r.jsx)(o.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.popoverModelPlotExplanation",defaultMessage:"If model plot is enabled, you can optionally show model bounds, which are represented by a shaded area in the chart. As the job analyzes more data, it learns to more closely predict the expected patterns of behavior."})))},52535:(e,t,s)=>{s.d(t,{e:()=>n,I:()=>r});var a=s(30770),o=s(75008),i=s(62106);function r(e,t,s,r,n,l){const c=r.jobs.filter(i.nO),u=c.map((e=>e.job_id)),d=(0,a.difference)(t,u),h=(0,a.without)(t,...d);if(1===d.length){const t=d[0],s=e.find((e=>e.id===t));if(void 0!==s&&void 0!==s.isNotSingleMetricViewerJobMessage){const e=o.i18n.translate("xpack.ml.timeSeriesExplorer.canNotViewRequestedJobsWarningWithReasonMessage",{defaultMessage:"You can't view {selectedJobId} in this dashboard because {reason}.",values:{selectedJobId:t,reason:s.isNotSingleMetricViewerJobMessage}});n.addWarning({title:e,"data-test-subj":"mlTimeSeriesExplorerDisabledJobReasonWarningToast"})}}if(d.length>1){let e=o.i18n.translate("xpack.ml.timeSeriesExplorer.canNotViewRequestedJobsWarningMessage",{defaultMessage:"You can't view requested {invalidIdsCount, plural, one {job} other {jobs}} {invalidIds} in this dashboard",values:{invalidIdsCount:d.length,invalidIds:d.join(", ")}});0===h.length&&u.length>0&&(e+=o.i18n.translate("xpack.ml.timeSeriesExplorer.autoSelectingFirstJobText",{defaultMessage:", auto selecting first job"})),n.addWarning(e)}return h.length>1?(n.addWarning(o.i18n.translate("xpack.ml.timeSeriesExplorer.youCanViewOneJobAtTimeWarningMessage",{defaultMessage:"You can only view one job at a time in this dashboard"})),s("ml",{jobIds:[h[0]]}),!0):d.length>0&&h.length>0?(s("ml",{jobIds:[h[0]]}),!0):1===h.length?h[0]:0===h.length&&c.length>0&&(l({singleSelection:!0,timeseriesOnly:!0}).then((({jobIds:e,time:t})=>{s({ml:{jobIds:e},...void 0!==t?{time:t}:{}})})).catch((e=>{})),!0)}function n(){return{chartDetails:void 0,contextAggregationInterval:void 0,contextChartData:void 0,contextForecastData:void 0,dataNotChartable:!1,entitiesLoading:!1,entityValues:{},focusAnnotationData:[],focusAggregationInterval:{},focusChartData:void 0,focusForecastData:void 0,fullRefresh:!0,hasResults:!1,loadCounter:0,loading:!1,modelPlotEnabled:!1,showAnnotations:!0,showAnnotationsCheckbox:!0,showForecast:!0,showForecastCheckbox:!1,showModelBounds:!0,showModelBoundsCheckbox:!1,svgWidth:0,tableData:void 0,zoomFrom:void 0,zoomTo:void 0,zoomFromFocusLoaded:void 0,zoomToFocusLoaded:void 0,chartDataError:void 0,sourceIndicesWithGeoFields:{}}}},17404:(e,t,s)=>{s.d(t,{$d:()=>d,A4:()=>M,Kv:()=>h,O6:()=>j,OF:()=>f,PF:()=>x,Vc:()=>w,gX:()=>E,k9:()=>_,lj:()=>g,nD:()=>m,pI:()=>y,pn:()=>F,rg:()=>S,wK:()=>p,z9:()=>C});var a=s(47935),o=s.n(a),i=s(73601),r=s(21069),n=s(51783),l=s.n(n),c=s(9506),u=s(48290);const d=7,h=5,m=10,p=100;function f(e=[],t){let s=1/0,a=-1/0;e.forEach((e=>{let t=e.value;const o=Array.isArray(e.actual)?e.actual[0]:e.actual,i=Array.isArray(e.typical)?e.typical[0]:e.typical;null===t&&void 0!==e.anomalyScore&&void 0!==e.actual&&(t=o),void 0!==e.anomalyScore&&void 0!==o?(s=Math.min(s,t,o,i),a=Math.max(a,t,o,i)):(s=Math.min(s,t),a=Math.max(a,t))}));const o={max:a,min:s};if(o.max===o.min){const e=.05*o.max;o.max+=e,o.min-=e}return"count"===t&&o.min<0&&(o.min=0),o}function g(e,t,s,a=1.5){const o=e.reduce(((t,s,a)=>{const o=e[a-1],i=e[a+1];return(void 0===o||o&&null===o.value)&&null!==s.value&&(void 0===i||i&&null===i.value)&&t.push(s),t}),[]),i=(t.select(".values-dots").empty()?t.append("g").classed("values-dots",!0):t.select(".values-dots")).selectAll("circle").data(o);i.enter().append("circle").attr("r",a),i.attr("cx",s.x()).attr("cy",s.y()),i.exit().remove()}function x(e,t){if(void 0===e||void 0===e.selectAll)throw new Error("Missing selection parameter");e.selectAll(".tick text").text((function(){const e=o().select(this.parentNode),s=e.node().getBBox().width,a=o().transform(e.attr("transform")).translate[0];if(a-s/2>=0&&a+s/2<=t)return this.textContent;e.remove()}))}const v=!0,b=!0;function y(e){let t=c.oT.SINGLE_METRIC;if("lat_long"===e.functionDescription||void 0!==e.mapData)return c.oT.GEO_MAP;if(v&&"rare"===e.functionDescription&&!1===e.entityFields.some((e=>"over"===e.fieldType))?t=c.oT.EVENT_DISTRIBUTION:b&&"rare"!==e.functionDescription&&e.entityFields.some((e=>"over"===e.fieldType))&&null!==e.metricFunction&&(t=c.oT.POPULATION_DISTRIBUTION),(t===c.oT.EVENT_DISTRIBUTION||t===c.oT.POPULATION_DISTRIBUTION)&&void 0!==e.datafeedConfig&&void 0!==e.datafeedConfig.script_fields){const s=Object.keys(e.datafeedConfig.script_fields),a=e.entityFields.map((e=>e.fieldName));e.metricFieldName&&a.push(e.metricFieldName),!0==(void 0!==a.find((e=>s.includes(e))))&&(t=c.oT.SINGLE_METRIC)}return t}async function S(e,t,s){const a=l()(t.plotEarliest).toISOString(),o=l()(t.plotLatest).toISOString();let i;return t.entityFields.length>0&&(i={},t.entityFields.forEach((e=>{i[e.fieldName]=e.fieldValue}))),await e.getUrl({page:u.Nh.SINGLE_METRIC_VIEWER,pageState:{jobIds:[t.jobId],refreshInterval:{display:"Off",pause:!0,value:0},timeRange:s,zoom:{from:a,to:o},detectorIndex:t.detectorIndex,entities:i,query:{query_string:{analyze_wildcard:!0,query:"*"}}}},{absolute:!0})}function M(e){return!0===e.isMultiBucketAnomaly}function F(e){return!0===e.isMultiBucketAnomaly}function E(e){const t=void 0!==e.multiBucketImpact?(0,i.qc)(e.multiBucketImpact):0;return new Array(5).fill("■ ",0,t).fill("□ ",t).join("")}function w(e,t){return e/(1.75*(0,r.Un)(l()().format(t),!1))}const k={NEXT:"next",PREVIOUS:"previous"};function j(e,t,s,a){if(t<=0)throw Error("tickInterval must be larger than 0.");const o=[e];function i(e,r){let n,l;switch(r){case k.PREVIOUS:n=e-t,l=n>=s;break;case k.NEXT:n=e+t,l=n<=a}l&&(o.push(n),i(n,r))}return i(e,k.PREVIOUS),i(e,k.NEXT),o.sort(),o}const A=60;function C({detectorLabel:e,entityFields:t}){return e.length+t.map((e=>`${e.fieldName} ${e.fieldValue}`)).join(" ").length>A}function _(e,t,s,a){function i(e){return function(t){switch(e){case k.PREVIOUS:return t-s;case k.NEXT:return t+s}}}function r(t,s){const n=function(t){const s=i(t),a=function(t){const i=e.selectAll(".tick").filter((e=>e===t));if(0===i.length||0===i[0].length)return!1;const r=o().selectAll(i[0]),n=r.select("text").node();if(null===n)return a(s(t));const l=n.getBBox().width,c=function(e){const t=/translate\(\s*([^\s,)]+)([ ,]([^\s,)]+))?\)/.exec(e);return Array.isArray(t)&&t.length>=2?Number(t[1]):NaN}(r.attr("transform"));return{tick:r,ts:t,xMinOffset:c-(l/2+15),xMaxOffset:c+(l/2+15)}};return a}(s),l=n(t);if(!1===l)return;const c=n(i(s)(t));!1!==c&&(c.xMinOffset<0||c.xMaxOffset>a||c.xMaxOffset>l.xMinOffset&&s===k.PREVIOUS||c.xMinOffset<l.xMaxOffset&&s===k.NEXT?(c.tick.select("text").remove(),c.tick.select("line").classed("ml-tick-emphasis",!1),r(l.ts,s)):r(c.ts,s))}e.selectAll("g.tick").select("line").classed("ml-tick-emphasis",!0),r(t,k.PREVIOUS),r(t,k.NEXT)}}}]);