"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCasesAttachments = registerCasesAttachments;
var _register_anomaly_charts_attachment = require("./register_anomaly_charts_attachment");
var _register_single_metric_viewer_attachment = require("./register_single_metric_viewer_attachment");
var _register_anomaly_swim_lane_attachment = require("./register_anomaly_swim_lane_attachment");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerCasesAttachments(cases, coreStart, pluginStart) {
  (0, _register_anomaly_swim_lane_attachment.registerAnomalySwimLaneCasesAttachment)(cases, pluginStart);
  (0, _register_anomaly_charts_attachment.registerAnomalyChartsCasesAttachment)(cases, coreStart, pluginStart);
  (0, _register_single_metric_viewer_attachment.registerSingleMetricViewerCasesAttachment)(cases, coreStart, pluginStart);
}