"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeBucketsServiceFactory = timeBucketsServiceFactory;
exports.useTimeBucketsService = useTimeBucketsService;
var _react = require("react");
var _public = require("@kbn/data-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _kibana = require("../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO Consolidate with legacy code in `ml/public/application/util/time_buckets.js`.
function timeBucketsServiceFactory(uiSettings) {
  function getTimeBuckets() {
    return new _mlTimeBuckets.TimeBuckets({
      [_public.UI_SETTINGS.HISTOGRAM_MAX_BARS]: uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_MAX_BARS),
      [_public.UI_SETTINGS.HISTOGRAM_BAR_TARGET]: uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
      dateFormat: uiSettings.get('dateFormat'),
      'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
    });
  }
  function getBoundsRoundedToInterval(bounds, interval, inclusiveEnd = false) {
    // Returns new bounds, created by flooring the min of the provided bounds to the start of
    // the specified interval (a moment duration), and rounded upwards (Math.ceil) to 1ms before
    // the start of the next interval (Kibana dashboards search >= bounds min, and <= bounds max,
    // so we subtract 1ms off the max to avoid querying start of the new Elasticsearch aggregation bucket).
    const intervalMs = interval.asMilliseconds();
    const adjustedMinMs = Math.floor(bounds.min.valueOf() / intervalMs) * intervalMs;
    let adjustedMaxMs = Math.ceil(bounds.max.valueOf() / intervalMs) * intervalMs;

    // Don't include the start ms of the next bucket unless specified..
    if (inclusiveEnd === false) {
      adjustedMaxMs = adjustedMaxMs - 1;
    }
    return {
      min: (0, _moment.default)(adjustedMinMs),
      max: (0, _moment.default)(adjustedMaxMs)
    };
  }
  return {
    getTimeBuckets,
    getBoundsRoundedToInterval
  };
}
function useTimeBucketsService() {
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const mlTimeBucketsService = (0, _react.useMemo)(() => timeBucketsServiceFactory(uiSettings), [uiSettings]);
  return mlTimeBucketsService;
}