"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStackManagementBreadcrumb = exports.getMlManagementBreadcrumb = exports.getBreadcrumbWithUrlForApp = exports.getADSettingsBreadcrumbs = exports.breadcrumbOnClickFactory = exports.TRAINED_MODELS_MANAGEMENT_BREADCRUMB = exports.SUPPLIED_CONFIGURATIONS_MANAGEMENT_BREADCRUMB = exports.SETTINGS_MANAGEMENT_BREADCRUMB = exports.ML_BREADCRUMB = exports.LOG_RATE_ANALYSIS_PAGE = exports.LOG_RATE_ANALYSIS = exports.LOG_PATTERN_ANALYSIS_PAGE = exports.LOG_PATTERN_ANALYSIS = exports.FILTER_LISTS_MANAGEMENT_BREADCRUMB = exports.DATA_VISUALIZER_BREADCRUMB = exports.DATA_FRAME_ANALYTICS_MANAGEMENT_BREADCRUMB = exports.DATA_DRIFT_PAGE = exports.DATA_DRIFT_INDEX_SELECT_BREADCRUMB = exports.DATA_DRIFT_BREADCRUMB = exports.CREATE_JOB_MANAGEMENT_BREADCRUMB = exports.CHANGE_POINT_DETECTION_PAGE = exports.CHANGE_POINT_DETECTION = exports.CALENDAR_LISTS_MANAGEMENT_BREADCRUMB = exports.CALENDAR_DST_LISTS_MANAGEMENT_BREADCRUMB = exports.ANOMALY_DETECTION_MANAGEMENT_BREADCRUMB = exports.AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS = exports.AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS = exports.AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION = void 0;
var _i18n = require("@kbn/i18n");
var _locator = require("../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stackManagementBreadcrumbText = _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.stackManagementLabel', {
  defaultMessage: 'Stack Management'
});
const ANOMALY_DETECTION_MANAGEMENT_BREADCRUMB = exports.ANOMALY_DETECTION_MANAGEMENT_BREADCRUMB = {
  text: _i18n.i18n.translate('xpack.ml.anomalyDetectionManagementBreadcrumbLabel', {
    defaultMessage: 'Anomaly detection jobs'
  }),
  appId: 'anomaly_detection',
  path: _locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE,
  deepLinkId: 'ml:anomalyDetection'
};
const CREATE_JOB_MANAGEMENT_BREADCRUMB = exports.CREATE_JOB_MANAGEMENT_BREADCRUMB = {
  text: _i18n.i18n.translate('xpack.ml.createJobManagementBreadcrumbLabel', {
    defaultMessage: 'Create job'
  }),
  path: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB,
  appId: `anomaly_detection`
};
const DATA_FRAME_ANALYTICS_MANAGEMENT_BREADCRUMB = exports.DATA_FRAME_ANALYTICS_MANAGEMENT_BREADCRUMB = {
  text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsManagementLabel', {
    defaultMessage: 'Data frame analytics jobs'
  }),
  appId: 'analytics',
  path: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE,
  deepLinkId: 'ml:dataFrameAnalytics'
};
const TRAINED_MODELS_MANAGEMENT_BREADCRUMB = exports.TRAINED_MODELS_MANAGEMENT_BREADCRUMB = {
  text: _i18n.i18n.translate('xpack.ml.trainedModelManagementLabel', {
    defaultMessage: 'Trained models'
  }),
  appId: 'trained_models',
  path: '',
  deepLinkId: 'management:trained_models'
};
const SUPPLIED_CONFIGURATIONS_MANAGEMENT_BREADCRUMB = exports.SUPPLIED_CONFIGURATIONS_MANAGEMENT_BREADCRUMB = {
  text: _i18n.i18n.translate('xpack.ml.suppliedConfigurationsManagementLabel', {
    defaultMessage: 'Supplied configurations'
  }),
  appId: `anomaly_detection`,
  path: 'ad_supplied_configurations',
  deepLinkId: 'ml:suppliedConfigurations'
};
const SETTINGS_MANAGEMENT_BREADCRUMB = exports.SETTINGS_MANAGEMENT_BREADCRUMB = {
  text: _i18n.i18n.translate('xpack.ml.settingsBreadcrumbLabel', {
    defaultMessage: 'Anomaly detection settings'
  }),
  appId: 'ad_settings',
  path: '',
  deepLinkId: 'ml:settings'
};
const FILTER_LISTS_MANAGEMENT_BREADCRUMB = exports.FILTER_LISTS_MANAGEMENT_BREADCRUMB = {
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.filterListsManagementLabel', {
    defaultMessage: 'Filter lists'
  }),
  appId: 'ad_settings',
  path: _locator.ML_PAGES.FILTER_LISTS_MANAGE,
  deepLinkId: 'ml:filterListsSettings'
};
const CALENDAR_LISTS_MANAGEMENT_BREADCRUMB = exports.CALENDAR_LISTS_MANAGEMENT_BREADCRUMB = {
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarListManagementLabel', {
    defaultMessage: 'Calendar management'
  }),
  appId: 'ad_settings',
  path: _locator.ML_PAGES.CALENDARS_MANAGE,
  deepLinkId: 'ml:calendarSettings'
};
const CALENDAR_DST_LISTS_MANAGEMENT_BREADCRUMB = exports.CALENDAR_DST_LISTS_MANAGEMENT_BREADCRUMB = {
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarListManagementLabel', {
    defaultMessage: 'Calendar DST management'
  }),
  appId: 'ad_settings',
  path: _locator.ML_PAGES.CALENDARS_DST_MANAGE,
  deepLinkId: 'ml:calendarSettings'
};
const ML_BREADCRUMB = exports.ML_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.machineLearningBreadcrumbLabel', {
    defaultMessage: 'Machine Learning'
  }),
  href: '/'
});
const DATA_VISUALIZER_BREADCRUMB = exports.DATA_VISUALIZER_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.datavisualizerBreadcrumbLabel', {
    defaultMessage: 'Data visualizer'
  }),
  href: '/datavisualizer',
  deepLinkId: 'ml:dataVisualizer'
});

// we need multiple AIOPS_BREADCRUMB breadcrumb items as they each need to link
// to each of the AIOps pages.
const AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS = exports.AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbLabel', {
    defaultMessage: 'AIOps Labs'
  }),
  href: '/aiops/log_rate_analysis_index_select'
});
const AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS = exports.AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbLabel', {
    defaultMessage: 'AIOps Labs'
  }),
  href: '/aiops/log_categorization_index_select'
});
const AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION = exports.AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbLabel', {
    defaultMessage: 'AIOps Labs'
  }),
  href: '/aiops/change_point_detection_index_select'
});
const LOG_RATE_ANALYSIS = exports.LOG_RATE_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.logRateAnalysisBreadcrumbLabel', {
    defaultMessage: 'Log rate analysis'
  }),
  href: '/aiops/log_rate_analysis_index_select',
  deepLinkId: 'ml:logRateAnalysis'
});
const LOG_RATE_ANALYSIS_PAGE = exports.LOG_RATE_ANALYSIS_PAGE = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.logRateAnalysisBreadcrumbLabel', {
    defaultMessage: 'Log rate analysis'
  }),
  href: '/aiops/log_rate_analysis',
  deepLinkId: 'ml:logRateAnalysisPage'
});
const LOG_PATTERN_ANALYSIS = exports.LOG_PATTERN_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.logPatternAnalysisBreadcrumbLabel', {
    defaultMessage: 'Log pattern analysis'
  }),
  href: '/aiops/log_categorization_index_select',
  deepLinkId: 'ml:logPatternAnalysis'
});
const LOG_PATTERN_ANALYSIS_PAGE = exports.LOG_PATTERN_ANALYSIS_PAGE = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.logPatternAnalysisBreadcrumbLabel', {
    defaultMessage: 'Log pattern analysis'
  }),
  href: '/aiops/log_categorization',
  deepLinkId: 'ml:logPatternAnalysisPage'
});
const CHANGE_POINT_DETECTION = exports.CHANGE_POINT_DETECTION = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.changePointDetectionBreadcrumbLabel', {
    defaultMessage: 'Change point detection'
  }),
  href: '/aiops/change_point_detection_index_select',
  deepLinkId: 'ml:changePointDetections'
});
const CHANGE_POINT_DETECTION_PAGE = exports.CHANGE_POINT_DETECTION_PAGE = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.changePointDetectionBreadcrumbLabel', {
    defaultMessage: 'Change point detection'
  }),
  href: '/aiops/change_point_detection',
  deepLinkId: 'ml:changePointDetectionsPage'
});
const DATA_DRIFT_BREADCRUMB = exports.DATA_DRIFT_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.dataComparisonLabel', {
    defaultMessage: 'Data drift'
  }),
  href: '/data_drift_index_select',
  deepLinkId: 'ml:dataDrift'
});
const DATA_DRIFT_PAGE = exports.DATA_DRIFT_PAGE = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.dataComparisonLabel', {
    defaultMessage: 'Data drift'
  }),
  href: '/data_drift',
  deepLinkId: 'ml:dataDriftPage'
});
const DATA_DRIFT_INDEX_SELECT_BREADCRUMB = exports.DATA_DRIFT_INDEX_SELECT_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.dataComparisonLabel', {
    defaultMessage: 'Select data view'
  }),
  href: '/data_drift_index_select',
  deepLinkId: 'ml:dataDrift'
});
const managementBreadcrumbs = {
  ANOMALY_DETECTION_MANAGEMENT_BREADCRUMB,
  CALENDAR_DST_LISTS_MANAGEMENT_BREADCRUMB,
  CALENDAR_LISTS_MANAGEMENT_BREADCRUMB,
  CREATE_JOB_MANAGEMENT_BREADCRUMB,
  DATA_FRAME_ANALYTICS_MANAGEMENT_BREADCRUMB,
  FILTER_LISTS_MANAGEMENT_BREADCRUMB,
  SUPPLIED_CONFIGURATIONS_MANAGEMENT_BREADCRUMB,
  SETTINGS_MANAGEMENT_BREADCRUMB,
  TRAINED_MODELS_MANAGEMENT_BREADCRUMB
};
const breadcrumbs = {
  ML_BREADCRUMB,
  DATA_DRIFT_INDEX_SELECT_BREADCRUMB,
  DATA_DRIFT_PAGE,
  DATA_VISUALIZER_BREADCRUMB,
  AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS,
  AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS,
  AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION,
  LOG_RATE_ANALYSIS,
  LOG_RATE_ANALYSIS_PAGE,
  LOG_PATTERN_ANALYSIS,
  LOG_PATTERN_ANALYSIS_PAGE,
  CHANGE_POINT_DETECTION,
  CHANGE_POINT_DETECTION_PAGE
};
const breadcrumbOnClickFactory = (path, navigateToPath) => {
  return e => {
    e.preventDefault();
    navigateToPath(path);
  };
};
exports.breadcrumbOnClickFactory = breadcrumbOnClickFactory;
const getBreadcrumbWithUrlForApp = (breadcrumbName, navigateToPath, basePath) => {
  return {
    text: breadcrumbs[breadcrumbName].text,
    ...(navigateToPath ? {
      href: `${basePath}/app/ml${breadcrumbs[breadcrumbName].href}`,
      deepLinkId: breadcrumbs[breadcrumbName].deepLinkId,
      onClick: breadcrumbOnClickFactory(breadcrumbs[breadcrumbName].href, navigateToPath)
    } : {})
  };
};
exports.getBreadcrumbWithUrlForApp = getBreadcrumbWithUrlForApp;
const getStackManagementBreadcrumb = navigateToApp => {
  return {
    text: stackManagementBreadcrumbText,
    onClick: e => {
      e.preventDefault();
      navigateToApp('management');
    }
  };
};
exports.getStackManagementBreadcrumb = getStackManagementBreadcrumb;
const getMlManagementBreadcrumb = (breadcrumbName, navigateToApp) => {
  const {
    appId,
    deepLinkId,
    path,
    text
  } = managementBreadcrumbs[breadcrumbName];
  return {
    text,
    onClick: e => {
      e.preventDefault();
      navigateToApp('management', {
        path: `/ml/${appId}/${path}`
      });
    },
    ...(deepLinkId ? {
      deepLinkId
    } : {})
  };
};
exports.getMlManagementBreadcrumb = getMlManagementBreadcrumb;
const getADSettingsBreadcrumbs = navigateToApp => {
  return [getStackManagementBreadcrumb(navigateToApp), getMlManagementBreadcrumb('ANOMALY_DETECTION_MANAGEMENT_BREADCRUMB', navigateToApp), getMlManagementBreadcrumb('SETTINGS_MANAGEMENT_BREADCRUMB', navigateToApp)];
};
exports.getADSettingsBreadcrumbs = getADSettingsBreadcrumbs;