"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _anomaly_detection_panel = require("./anomaly_detection_panel");
var _analytics_panel = require("./analytics_panel");
var _anomaly_timeline_service = require("../../services/anomaly_timeline_service");
var _kibana = require("../../contexts/kibana");
var _ml = require("../../contexts/ml");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/components/content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OverviewContent = ({
  createAnomalyDetectionJobDisabled,
  setAdLazyJobCount,
  setDfaLazyJobCount
}) => {
  const {
    services: {
      uiSettings,
      mlServices: {
        mlApi
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    isADEnabled,
    isDFAEnabled
  } = (0, _ml.useEnabledFeatures)();
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const [anomalyTimelineService, setAnomalyTimelineService] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    setAnomalyTimelineService(new _anomaly_timeline_service.AnomalyTimelineService(timefilter, uiSettings, mlApi));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (anomalyTimelineService === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isADEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_anomaly_detection_panel.AnomalyDetectionPanel, {
    anomalyTimelineService: anomalyTimelineService,
    setLazyJobCount: setAdLazyJobCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  })) : null, isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_analytics_panel.AnalyticsPanel, {
    setLazyJobCount: setDfaLazyJobCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 23
    }
  }) : null);
};
exports.OverviewContent = OverviewContent;